package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.logging.Level;

/**
 * Defines a syslog handler.
 */
@Addresses({"/subsystem=logging/syslog-handler=*",
		"/subsystem=logging/logging-profile=*/syslog-handler=*"})
@ResourceType("syslog-handler")
public class SyslogHandler<T extends SyslogHandler<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private String appName;
	private Boolean enabled;
	private Facility facility;
	private String hostname;
	private Level level;
	private Integer port;
	private String serverAddress;
	private SyslogFormat syslogFormat;

	public SyslogHandler(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Facility {
		KERNEL("kernel"), USER_LEVEL("user-level"), MAIL_SYSTEM("mail-system"), SYSTEM_DAEMONS(
				"system-daemons"), SECURITY("security"), SYSLOGD("syslogd"), LINE_PRINTER(
				"line-printer"), NETWORK_NEWS("network-news"), UUCP("uucp"), CLOCK_DAEMON(
				"clock-daemon"), SECURITY2("security2"), FTP_DAEMON(
				"ftp-daemon"), NTP("ntp"), LOG_AUDIT("log-audit"), LOG_ALERT(
				"log-alert"), CLOCK_DAEMON2("clock-daemon2"), LOCAL_USE_0(
				"local-use-0"), LOCAL_USE_1("local-use-1"), LOCAL_USE_2(
				"local-use-2"), LOCAL_USE_3("local-use-3"), LOCAL_USE_4(
				"local-use-4"), LOCAL_USE_5("local-use-5"), LOCAL_USE_6(
				"local-use-6"), LOCAL_USE_7("local-use-7");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Facility(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum SyslogFormat {
		RFC5424("RFC5424"), RFC3164("RFC3164");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		SyslogFormat(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The app name used when formatting the message in RFC5424 format. By
	 * default the app name is "java".
	 */
	@ModelNodeBinding(detypedName = "app-name")
	public String appName() {
		return this.appName;
	}

	/**
	 * The app name used when formatting the message in RFC5424 format. By
	 * default the app name is "java".
	 */
	@SuppressWarnings("unchecked")
	public T appName(java.lang.String value) {
		Object oldValue = this.appName;
		this.appName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("appName", oldValue, value);
		return (T) this;
	}

	/**
	 * If set to true the handler is enabled and functioning as normal, if set
	 * to false the handler is ignored when processing log messages.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If set to true the handler is enabled and functioning as normal, if set
	 * to false the handler is ignored when processing log messages.
	 */
	@SuppressWarnings("unchecked")
	public T enabled(java.lang.Boolean value) {
		Object oldValue = this.enabled;
		this.enabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Facility as defined by RFC-5424 (http://tools.ietf.org/html/rfc5424)and
	 * RFC-3164 (http://tools.ietf.org/html/rfc3164).
	 */
	@ModelNodeBinding(detypedName = "facility")
	public Facility facility() {
		return this.facility;
	}

	/**
	 * Facility as defined by RFC-5424 (http://tools.ietf.org/html/rfc5424)and
	 * RFC-3164 (http://tools.ietf.org/html/rfc3164).
	 */
	@SuppressWarnings("unchecked")
	public T facility(Facility value) {
		Object oldValue = this.facility;
		this.facility = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("facility", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the host the messages are being sent from. For example the
	 * name of the host the application server is running on.
	 */
	@ModelNodeBinding(detypedName = "hostname")
	public String hostname() {
		return this.hostname;
	}

	/**
	 * The name of the host the messages are being sent from. For example the
	 * name of the host the application server is running on.
	 */
	@SuppressWarnings("unchecked")
	public T hostname(java.lang.String value) {
		Object oldValue = this.hostname;
		this.hostname = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hostname", oldValue, value);
		return (T) this;
	}

	/**
	 * The log level specifying which message levels will be logged by this
	 * logger. Message levels lower than this value will be discarded.
	 */
	@ModelNodeBinding(detypedName = "level")
	public Level level() {
		return this.level;
	}

	/**
	 * The log level specifying which message levels will be logged by this
	 * logger. Message levels lower than this value will be discarded.
	 */
	@SuppressWarnings("unchecked")
	public T level(Level value) {
		Object oldValue = this.level;
		this.level = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("level", oldValue, value);
		return (T) this;
	}

	/**
	 * The port the syslog server is listening on.
	 */
	@ModelNodeBinding(detypedName = "port")
	public Integer port() {
		return this.port;
	}

	/**
	 * The port the syslog server is listening on.
	 */
	@SuppressWarnings("unchecked")
	public T port(java.lang.Integer value) {
		Object oldValue = this.port;
		this.port = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("port", oldValue, value);
		return (T) this;
	}

	/**
	 * The address of the syslog server.
	 */
	@ModelNodeBinding(detypedName = "server-address")
	public String serverAddress() {
		return this.serverAddress;
	}

	/**
	 * The address of the syslog server.
	 */
	@SuppressWarnings("unchecked")
	public T serverAddress(java.lang.String value) {
		Object oldValue = this.serverAddress;
		this.serverAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * Formats the log message according to the RFC specification.
	 */
	@ModelNodeBinding(detypedName = "syslog-format")
	public SyslogFormat syslogFormat() {
		return this.syslogFormat;
	}

	/**
	 * Formats the log message according to the RFC specification.
	 */
	@SuppressWarnings("unchecked")
	public T syslogFormat(SyslogFormat value) {
		Object oldValue = this.syslogFormat;
		this.syslogFormat = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("syslogFormat", oldValue, value);
		return (T) this;
	}
}