package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.security.security_domain.ClassicMapping;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ClassicMappingConsumer<T extends ClassicMapping<T>> {

	/**
	 * Configure a pre-constructed instance of ClassicMapping resource
	 * 
	 * @parameter Instance of ClassicMapping to configure
	 * @return nothing
	 */
	void accept(T value);

	default ClassicMappingConsumer<T> andThen(ClassicMappingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}