package org.wildfly.swarm.config.webservices;

import org.wildfly.swarm.config.webservices.Handler;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface HandlerConsumer<T extends Handler<T>> {

	/**
	 * Configure a pre-constructed instance of Handler resource
	 * 
	 * @parameter Instance of Handler to configure
	 * @return nothing
	 */
	void accept(T value);

	default HandlerConsumer<T> andThen(HandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}