/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.singleton.SingletonPolicy;
import org.wildfly.swarm.config.singleton.SingletonPolicyConsumer;
import org.wildfly.swarm.config.singleton.SingletonPolicySupplier;

@Address(value="/subsystem=singleton")
@ResourceType(value="subsystem")
@Implicit
public class Singleton<T extends Singleton<T>>
extends HashMap
implements Keyed {
    private String key = "singleton";
    private PropertyChangeSupport pcs;
    private SingletonResources subresources = new SingletonResources();
    private String attributeDefault;

    public Singleton() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SingletonResources subresources() {
        return this.subresources;
    }

    public T singletonPolicies(List<SingletonPolicy> value) {
        this.subresources.singletonPolicies = value;
        return (T)this;
    }

    public T singletonPolicy(SingletonPolicy value) {
        this.subresources.singletonPolicies.add(value);
        return (T)this;
    }

    public T singletonPolicy(String childKey, SingletonPolicyConsumer consumer) {
        SingletonPolicy child = new SingletonPolicy(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.singletonPolicy(child);
        return (T)this;
    }

    public T singletonPolicy(String childKey) {
        this.singletonPolicy(childKey, null);
        return (T)this;
    }

    public T singletonPolicy(SingletonPolicySupplier supplier) {
        this.singletonPolicy(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default")
    public String attributeDefault() {
        return this.attributeDefault;
    }

    public T attributeDefault(String value) {
        String oldValue = this.attributeDefault;
        this.attributeDefault = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeDefault", oldValue, value);
        }
        return (T)this;
    }

    public static class SingletonResources {
        @SubresourceInfo(value="singletonPolicy")
        private List<SingletonPolicy> singletonPolicies = new ArrayList<SingletonPolicy>();

        @Subresource
        public List<SingletonPolicy> singletonPolicies() {
            return this.singletonPolicies;
        }

        public SingletonPolicy singletonPolicy(String key) {
            return this.singletonPolicies.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

