/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.undertow.server.AJPListener;
import org.wildfly.swarm.config.undertow.server.AJPListenerConsumer;
import org.wildfly.swarm.config.undertow.server.AJPListenerSupplier;
import org.wildfly.swarm.config.undertow.server.HTTPListener;
import org.wildfly.swarm.config.undertow.server.HTTPListenerConsumer;
import org.wildfly.swarm.config.undertow.server.HTTPListenerSupplier;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.server.HostConsumer;
import org.wildfly.swarm.config.undertow.server.HostSupplier;
import org.wildfly.swarm.config.undertow.server.HttpsListener;
import org.wildfly.swarm.config.undertow.server.HttpsListenerConsumer;
import org.wildfly.swarm.config.undertow.server.HttpsListenerSupplier;

@Address(value="/subsystem=undertow/server=*")
@ResourceType(value="server")
public class Server<T extends Server<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ServerResources subresources = new ServerResources();
    private String defaultHost;
    private String servletContainer;

    public Server(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ServerResources subresources() {
        return this.subresources;
    }

    public T hosts(List<Host> value) {
        this.subresources.hosts = value;
        return (T)this;
    }

    public T host(Host value) {
        this.subresources.hosts.add(value);
        return (T)this;
    }

    public T host(String childKey, HostConsumer consumer) {
        Host child = new Host(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.host(child);
        return (T)this;
    }

    public T host(String childKey) {
        this.host(childKey, null);
        return (T)this;
    }

    public T host(HostSupplier supplier) {
        this.host(supplier.get());
        return (T)this;
    }

    public T httpListeners(List<HTTPListener> value) {
        this.subresources.httpListeners = value;
        return (T)this;
    }

    public T httpListener(HTTPListener value) {
        this.subresources.httpListeners.add(value);
        return (T)this;
    }

    public T httpListener(String childKey, HTTPListenerConsumer consumer) {
        HTTPListener child = new HTTPListener(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.httpListener(child);
        return (T)this;
    }

    public T httpListener(String childKey) {
        this.httpListener(childKey, null);
        return (T)this;
    }

    public T httpListener(HTTPListenerSupplier supplier) {
        this.httpListener(supplier.get());
        return (T)this;
    }

    public T ajpListeners(List<AJPListener> value) {
        this.subresources.ajpListeners = value;
        return (T)this;
    }

    public T ajpListener(AJPListener value) {
        this.subresources.ajpListeners.add(value);
        return (T)this;
    }

    public T ajpListener(String childKey, AJPListenerConsumer consumer) {
        AJPListener child = new AJPListener(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.ajpListener(child);
        return (T)this;
    }

    public T ajpListener(String childKey) {
        this.ajpListener(childKey, null);
        return (T)this;
    }

    public T ajpListener(AJPListenerSupplier supplier) {
        this.ajpListener(supplier.get());
        return (T)this;
    }

    public T httpsListeners(List<HttpsListener> value) {
        this.subresources.httpsListeners = value;
        return (T)this;
    }

    public T httpsListener(HttpsListener value) {
        this.subresources.httpsListeners.add(value);
        return (T)this;
    }

    public T httpsListener(String childKey, HttpsListenerConsumer consumer) {
        HttpsListener child = new HttpsListener(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.httpsListener(child);
        return (T)this;
    }

    public T httpsListener(String childKey) {
        this.httpsListener(childKey, null);
        return (T)this;
    }

    public T httpsListener(HttpsListenerSupplier supplier) {
        this.httpsListener(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-host")
    public String defaultHost() {
        return this.defaultHost;
    }

    public T defaultHost(String value) {
        String oldValue = this.defaultHost;
        this.defaultHost = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultHost", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="servlet-container")
    public String servletContainer() {
        return this.servletContainer;
    }

    public T servletContainer(String value) {
        String oldValue = this.servletContainer;
        this.servletContainer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("servletContainer", oldValue, value);
        }
        return (T)this;
    }

    public static class ServerResources {
        @SubresourceInfo(value="host")
        private List<Host> hosts = new ArrayList<Host>();
        @SubresourceInfo(value="httpListener")
        private List<HTTPListener> httpListeners = new ArrayList<HTTPListener>();
        @SubresourceInfo(value="ajpListener")
        private List<AJPListener> ajpListeners = new ArrayList<AJPListener>();
        @SubresourceInfo(value="httpsListener")
        private List<HttpsListener> httpsListeners = new ArrayList<HttpsListener>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }

        public Host host(String key) {
            return this.hosts.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<HTTPListener> httpListeners() {
            return this.httpListeners;
        }

        public HTTPListener httpListener(String key) {
            return this.httpListeners.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<AJPListener> ajpListeners() {
            return this.ajpListeners;
        }

        public AJPListener ajpListener(String key) {
            return this.ajpListeners.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<HttpsListener> httpsListeners() {
            return this.httpsListeners;
        }

        public HttpsListener httpsListener(String key) {
            return this.httpsListeners.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

