/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.Balancer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.BalancerConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.BalancerSupplier;

@Address(value="/subsystem=undertow/configuration=filter/mod-cluster=*")
@ResourceType(value="mod-cluster")
public class ModCluster<T extends ModCluster<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ModClusterResources subresources = new ModClusterResources();
    private Integer advertiseFrequency;
    private String advertisePath;
    private String advertiseProtocol;
    private String advertiseSocketBinding;
    private Integer brokenNodeTimeout;
    private Integer cachedConnectionsPerThread;
    private Integer connectionIdleTimeout;
    private Integer connectionsPerThread;
    private Boolean enableHttp2;
    private Integer healthCheckInterval;
    private Boolean http2EnablePush;
    private Integer http2HeaderTableSize;
    private Integer http2InitialWindowSize;
    private Integer http2MaxConcurrentStreams;
    private Integer http2MaxFrameSize;
    private Integer http2MaxHeaderListSize;
    private String managementAccessPredicate;
    private String managementSocketBinding;
    private Integer maxAjpPacketSize;
    private Integer maxRequestTime;
    private Integer requestQueueSize;
    private String securityKey;
    private String securityRealm;
    private Boolean useAlias;
    private String worker;

    public ModCluster(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ModClusterResources subresources() {
        return this.subresources;
    }

    public T balancers(List<Balancer> value) {
        this.subresources.balancers = value;
        return (T)this;
    }

    public T balancer(Balancer value) {
        this.subresources.balancers.add(value);
        return (T)this;
    }

    public T balancer(String childKey, BalancerConsumer consumer) {
        Balancer child = new Balancer(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.balancer(child);
        return (T)this;
    }

    public T balancer(String childKey) {
        this.balancer(childKey, null);
        return (T)this;
    }

    public T balancer(BalancerSupplier supplier) {
        this.balancer(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-frequency")
    public Integer advertiseFrequency() {
        return this.advertiseFrequency;
    }

    public T advertiseFrequency(Integer value) {
        Integer oldValue = this.advertiseFrequency;
        this.advertiseFrequency = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertiseFrequency", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-path")
    public String advertisePath() {
        return this.advertisePath;
    }

    public T advertisePath(String value) {
        String oldValue = this.advertisePath;
        this.advertisePath = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertisePath", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-protocol")
    public String advertiseProtocol() {
        return this.advertiseProtocol;
    }

    public T advertiseProtocol(String value) {
        String oldValue = this.advertiseProtocol;
        this.advertiseProtocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertiseProtocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-socket-binding")
    public String advertiseSocketBinding() {
        return this.advertiseSocketBinding;
    }

    public T advertiseSocketBinding(String value) {
        String oldValue = this.advertiseSocketBinding;
        this.advertiseSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertiseSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="broken-node-timeout")
    public Integer brokenNodeTimeout() {
        return this.brokenNodeTimeout;
    }

    public T brokenNodeTimeout(Integer value) {
        Integer oldValue = this.brokenNodeTimeout;
        this.brokenNodeTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("brokenNodeTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cached-connections-per-thread")
    public Integer cachedConnectionsPerThread() {
        return this.cachedConnectionsPerThread;
    }

    public T cachedConnectionsPerThread(Integer value) {
        Integer oldValue = this.cachedConnectionsPerThread;
        this.cachedConnectionsPerThread = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cachedConnectionsPerThread", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-idle-timeout")
    public Integer connectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public T connectionIdleTimeout(Integer value) {
        Integer oldValue = this.connectionIdleTimeout;
        this.connectionIdleTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionIdleTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connections-per-thread")
    public Integer connectionsPerThread() {
        return this.connectionsPerThread;
    }

    public T connectionsPerThread(Integer value) {
        Integer oldValue = this.connectionsPerThread;
        this.connectionsPerThread = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionsPerThread", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-http2")
    public Boolean enableHttp2() {
        return this.enableHttp2;
    }

    public T enableHttp2(Boolean value) {
        Boolean oldValue = this.enableHttp2;
        this.enableHttp2 = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableHttp2", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="health-check-interval")
    public Integer healthCheckInterval() {
        return this.healthCheckInterval;
    }

    public T healthCheckInterval(Integer value) {
        Integer oldValue = this.healthCheckInterval;
        this.healthCheckInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("healthCheckInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-enable-push")
    public Boolean http2EnablePush() {
        return this.http2EnablePush;
    }

    public T http2EnablePush(Boolean value) {
        Boolean oldValue = this.http2EnablePush;
        this.http2EnablePush = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2EnablePush", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-header-table-size")
    public Integer http2HeaderTableSize() {
        return this.http2HeaderTableSize;
    }

    public T http2HeaderTableSize(Integer value) {
        Integer oldValue = this.http2HeaderTableSize;
        this.http2HeaderTableSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2HeaderTableSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-initial-window-size")
    public Integer http2InitialWindowSize() {
        return this.http2InitialWindowSize;
    }

    public T http2InitialWindowSize(Integer value) {
        Integer oldValue = this.http2InitialWindowSize;
        this.http2InitialWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2InitialWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-max-concurrent-streams")
    public Integer http2MaxConcurrentStreams() {
        return this.http2MaxConcurrentStreams;
    }

    public T http2MaxConcurrentStreams(Integer value) {
        Integer oldValue = this.http2MaxConcurrentStreams;
        this.http2MaxConcurrentStreams = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2MaxConcurrentStreams", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-max-frame-size")
    public Integer http2MaxFrameSize() {
        return this.http2MaxFrameSize;
    }

    public T http2MaxFrameSize(Integer value) {
        Integer oldValue = this.http2MaxFrameSize;
        this.http2MaxFrameSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2MaxFrameSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-max-header-list-size")
    public Integer http2MaxHeaderListSize() {
        return this.http2MaxHeaderListSize;
    }

    public T http2MaxHeaderListSize(Integer value) {
        Integer oldValue = this.http2MaxHeaderListSize;
        this.http2MaxHeaderListSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2MaxHeaderListSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="management-access-predicate")
    public String managementAccessPredicate() {
        return this.managementAccessPredicate;
    }

    public T managementAccessPredicate(String value) {
        String oldValue = this.managementAccessPredicate;
        this.managementAccessPredicate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("managementAccessPredicate", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="management-socket-binding")
    public String managementSocketBinding() {
        return this.managementSocketBinding;
    }

    public T managementSocketBinding(String value) {
        String oldValue = this.managementSocketBinding;
        this.managementSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("managementSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-ajp-packet-size")
    public Integer maxAjpPacketSize() {
        return this.maxAjpPacketSize;
    }

    public T maxAjpPacketSize(Integer value) {
        Integer oldValue = this.maxAjpPacketSize;
        this.maxAjpPacketSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxAjpPacketSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-request-time")
    public Integer maxRequestTime() {
        return this.maxRequestTime;
    }

    public T maxRequestTime(Integer value) {
        Integer oldValue = this.maxRequestTime;
        this.maxRequestTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRequestTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-queue-size")
    public Integer requestQueueSize() {
        return this.requestQueueSize;
    }

    public T requestQueueSize(Integer value) {
        Integer oldValue = this.requestQueueSize;
        this.requestQueueSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestQueueSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-key")
    public String securityKey() {
        return this.securityKey;
    }

    public T securityKey(String value) {
        String oldValue = this.securityKey;
        this.securityKey = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityKey", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public T securityRealm(String value) {
        String oldValue = this.securityRealm;
        this.securityRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-alias")
    public Boolean useAlias() {
        return this.useAlias;
    }

    public T useAlias(Boolean value) {
        Boolean oldValue = this.useAlias;
        this.useAlias = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useAlias", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker")
    public String worker() {
        return this.worker;
    }

    public T worker(String value) {
        String oldValue = this.worker;
        this.worker = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("worker", oldValue, value);
        }
        return (T)this;
    }

    public static class ModClusterResources {
        @SubresourceInfo(value="balancer")
        private List<Balancer> balancers = new ArrayList<Balancer>();

        @Subresource
        public List<Balancer> balancers() {
            return this.balancers;
        }

        public Balancer balancer(String key) {
            return this.balancers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

