package org.wildfly.swarm.config;

import org.wildfly.swarm.config.RequestController;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RequestControllerConsumer<T extends RequestController<T>> {

	/**
	 * Configure a pre-constructed instance of RequestController resource
	 * 
	 * @parameter Instance of RequestController to configure
	 * @return nothing
	 */
	void accept(T value);

	default RequestControllerConsumer<T> andThen(
			RequestControllerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}