package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.BackupForComponent;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface BackupForComponentConsumer<T extends BackupForComponent<T>> {

	/**
	 * Configure a pre-constructed instance of BackupForComponent resource
	 * 
	 * @parameter Instance of BackupForComponent to configure
	 * @return nothing
	 */
	void accept(T value);

	default BackupForComponentConsumer<T> andThen(
			BackupForComponentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}