package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptor;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface InVMAcceptorConsumer<T extends InVMAcceptor<T>> {

	/**
	 * Configure a pre-constructed instance of InVMAcceptor resource
	 * 
	 * @parameter Instance of InVMAcceptor to configure
	 * @return nothing
	 */
	void accept(T value);

	default InVMAcceptorConsumer<T> andThen(InVMAcceptorConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}