package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.PropertyConsumer;
import org.wildfly.swarm.config.remoting.PropertySupplier;
import org.wildfly.swarm.config.remoting.Property;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.remoting.SASLSecurityConsumer;
import org.wildfly.swarm.config.remoting.SASLSecuritySupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of a Remoting connector.
 */
@Address("/subsystem=remoting/connector=*")
@ResourceType("connector")
public class Connector<T extends Connector<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ConnectorResources subresources = new ConnectorResources();
	private String authenticationProvider;
	private String saslProtocol;
	private String securityRealm;
	private String serverName;
	private String socketBinding;

	public Connector(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ConnectorResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Property objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.List<Property> value) {
		this.subresources.properties = value;
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * 
	 * @param value
	 *            The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.properties.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Property object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Property resource
	 * @param config
	 *            The PropertyConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String childKey, PropertyConsumer consumer) {
		Property<? extends Property> child = new Property<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		property(child);
		return (T) this;
	}

	/**
	 * Create and configure a Property object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Property resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String childKey) {
		property(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Property object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T property(PropertySupplier supplier) {
		property(supplier.get());
		return (T) this;
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for
	 * this connector.
	 */
	@SuppressWarnings("unchecked")
	public T saslSecurity(org.wildfly.swarm.config.remoting.SASLSecurity value) {
		this.subresources.saslSecurity = value;
		return (T) this;
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for
	 * this connector.
	 */
	@SuppressWarnings("unchecked")
	public T saslSecurity(SASLSecurityConsumer consumer) {
		SASLSecurity<? extends SASLSecurity> child = new SASLSecurity<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.saslSecurity = child;
		return (T) this;
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for
	 * this connector.
	 */
	@SuppressWarnings("unchecked")
	public T saslSecurity() {
		SASLSecurity<? extends SASLSecurity> child = new SASLSecurity<>();
		this.subresources.saslSecurity = child;
		return (T) this;
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for
	 * this connector.
	 */
	@SuppressWarnings("unchecked")
	public T saslSecurity(SASLSecuritySupplier supplier) {
		this.subresources.saslSecurity = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Connector
	 */
	public static class ConnectorResources {
		/**
		 * Properties supported by the underlying provider. The property name is
		 * inferred from the last element of the properties address.
		 */
		@SubresourceInfo("property")
		private List<Property> properties = new java.util.ArrayList<>();
		private SASLSecurity saslSecurity;

		/**
		 * Get the list of Property resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> properties() {
			return this.properties;
		}

		public Property property(java.lang.String key) {
			return this.properties.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * The "sasl" element contains the SASL authentication configuration for
		 * this connector.
		 */
		@Subresource
		public SASLSecurity saslSecurity() {
			return this.saslSecurity;
		}
	}

	/**
	 * The "authentication-provider" element contains the name of the
	 * authentication provider to use for incoming connections.
	 */
	@ModelNodeBinding(detypedName = "authentication-provider")
	public String authenticationProvider() {
		return this.authenticationProvider;
	}

	/**
	 * The "authentication-provider" element contains the name of the
	 * authentication provider to use for incoming connections.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationProvider(java.lang.String value) {
		Object oldValue = this.authenticationProvider;
		this.authenticationProvider = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authenticationProvider", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The protocol to pass into the SASL mechanisms used for authentication.
	 */
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * The protocol to pass into the SASL mechanisms used for authentication.
	 */
	@SuppressWarnings("unchecked")
	public T saslProtocol(java.lang.String value) {
		Object oldValue = this.saslProtocol;
		this.saslProtocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslProtocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The associated security realm to use for authentication for this
	 * connector.
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The associated security realm to use for authentication for this
	 * connector.
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(java.lang.String value) {
		Object oldValue = this.securityRealm;
		this.securityRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * The server name to send in the initial message exchange and for SASL
	 * based authentication.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The server name to send in the initial message exchange and for SASL
	 * based authentication.
	 */
	@SuppressWarnings("unchecked")
	public T serverName(java.lang.String value) {
		Object oldValue = this.serverName;
		this.serverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name (or names) of the socket binding(s) to attach to.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The name (or names) of the socket binding(s) to attach to.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}
}