package org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Runtime representation of a mod_cluster context
 */
@Address("/subsystem=undertow/configuration=filter/mod-cluster=*/balancer=*/node=*/context=*")
@ResourceType("context")
public class Context<T extends Context<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer requests;
	private String status;

	public Context(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The number of requests against this context
	 */
	@ModelNodeBinding(detypedName = "requests")
	public Integer requests() {
		return this.requests;
	}

	/**
	 * The number of requests against this context
	 */
	@SuppressWarnings("unchecked")
	public T requests(java.lang.Integer value) {
		Object oldValue = this.requests;
		this.requests = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("requests", oldValue, value);
		return (T) this;
	}

	/**
	 * The status of this context
	 */
	@ModelNodeBinding(detypedName = "status")
	public String status() {
		return this.status;
	}

	/**
	 * The status of this context
	 */
	@SuppressWarnings("unchecked")
	public T status(java.lang.String value) {
		Object oldValue = this.status;
		this.status = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("status", oldValue, value);
		return (T) this;
	}
}