package org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node;

import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ContextConsumer<T extends Context<T>> {

	/**
	 * Configure a pre-constructed instance of Context resource
	 * 
	 * @parameter Instance of Context to configure
	 * @return nothing
	 */
	void accept(T value);

	default ContextConsumer<T> andThen(ContextConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}