/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.remoting;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.remoting.Property;
import org.wildfly.swarm.config.remoting.PropertyConsumer;
import org.wildfly.swarm.config.remoting.PropertySupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=remoting/local-outbound-connection=*")
@ResourceType(value="local-outbound-connection")
public class LocalOutboundConnection<T extends LocalOutboundConnection<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private LocalOutboundConnectionResources subresources = new LocalOutboundConnectionResources();
    private String outboundSocketBindingRef;

    public LocalOutboundConnection(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public LocalOutboundConnectionResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="outbound-socket-binding-ref")
    public String outboundSocketBindingRef() {
        return this.outboundSocketBindingRef;
    }

    public T outboundSocketBindingRef(String value) {
        String oldValue = this.outboundSocketBindingRef;
        this.outboundSocketBindingRef = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("outboundSocketBindingRef", oldValue, value);
        }
        return (T)this;
    }

    public static class LocalOutboundConnectionResources {
        @SubresourceInfo(value="property")
        private List<Property> properties = new ArrayList<Property>();

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

