package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.resource.adapters.ResourceAdapterConsumer;
import org.wildfly.swarm.config.resource.adapters.ResourceAdapterSupplier;
import org.wildfly.swarm.config.resource.adapters.ResourceAdapter;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration of the resource adapters subsystem.
 */
@Address("/subsystem=resource-adapters")
@ResourceType("subsystem")
@Implicit
public class ResourceAdapters<T extends ResourceAdapters<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ResourceAdaptersResources subresources = new ResourceAdaptersResources();

	public ResourceAdapters() {
		super();
		this.key = "resource-adapters";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ResourceAdaptersResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ResourceAdapter objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ResourceAdapter objects.
	 */
	@SuppressWarnings("unchecked")
	public T resourceAdapters(java.util.List<ResourceAdapter> value) {
		this.subresources.resourceAdapters = value;
		return (T) this;
	}

	/**
	 * Add the ResourceAdapter object to the list of subresources
	 * 
	 * @param value
	 *            The ResourceAdapter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T resourceAdapter(ResourceAdapter value) {
		this.subresources.resourceAdapters.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ResourceAdapter object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ResourceAdapter resource
	 * @param config
	 *            The ResourceAdapterConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T resourceAdapter(java.lang.String childKey,
			ResourceAdapterConsumer consumer) {
		ResourceAdapter<? extends ResourceAdapter> child = new ResourceAdapter<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		resourceAdapter(child);
		return (T) this;
	}

	/**
	 * Create and configure a ResourceAdapter object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ResourceAdapter resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T resourceAdapter(java.lang.String childKey) {
		resourceAdapter(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ResourceAdapter object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T resourceAdapter(ResourceAdapterSupplier supplier) {
		resourceAdapter(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ResourceAdapters
	 */
	public static class ResourceAdaptersResources {
		/**
		 * The configuration of a resource adapter.
		 */
		@SubresourceInfo("resourceAdapter")
		private List<ResourceAdapter> resourceAdapters = new java.util.ArrayList<>();

		/**
		 * Get the list of ResourceAdapter resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ResourceAdapter> resourceAdapters() {
			return this.resourceAdapters;
		}

		public ResourceAdapter resourceAdapter(java.lang.String key) {
			return this.resourceAdapters.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}