package org.wildfly.swarm.config.ee;

import org.wildfly.swarm.config.ee.ManagedExecutorService;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ManagedExecutorServiceConsumer<T extends ManagedExecutorService<T>> {

	/**
	 * Configure a pre-constructed instance of ManagedExecutorService resource
	 * 
	 * @parameter Instance of ManagedExecutorService to configure
	 * @return nothing
	 */
	void accept(T value);

	default ManagedExecutorServiceConsumer<T> andThen(
			ManagedExecutorServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}