package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.PersistenceThreadPool;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PersistenceThreadPoolConsumer<T extends PersistenceThreadPool<T>> {

	/**
	 * Configure a pre-constructed instance of PersistenceThreadPool resource
	 * 
	 * @parameter Instance of PersistenceThreadPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default PersistenceThreadPoolConsumer<T> andThen(
			PersistenceThreadPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}