package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.math.BigDecimal;
import java.util.List;
import java.util.Arrays;

/**
 * The function of a bridge is to consume messages from a source queue, and
 * forward them to a target address, typically on a different ActiveMQ server.
 */
@Address("/subsystem=messaging-activemq/server=*/bridge=*")
@ResourceType("bridge")
public class Bridge<T extends Bridge<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private Long checkPeriod;
	private Integer confirmationWindowSize;
	private Long connectionTtl;
	private String discoveryGroup;
	private String filter;
	private String forwardingAddress;
	private Boolean ha;
	private Integer initialConnectAttempts;
	private Long maxRetryInterval;
	private Integer minLargeMessageSize;
	private String password;
	private String queueName;
	private Integer reconnectAttempts;
	private Integer reconnectAttemptsOnSameNode;
	private Long retryInterval;
	private BigDecimal retryIntervalMultiplier;
	private Boolean started;
	private List<String> staticConnectors;
	private String transformerClassName;
	private Boolean useDuplicateDetection;
	private String user;

	public Bridge(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The period (in milliseconds) between client failure check.
	 */
	@ModelNodeBinding(detypedName = "check-period")
	public Long checkPeriod() {
		return this.checkPeriod;
	}

	/**
	 * The period (in milliseconds) between client failure check.
	 */
	@SuppressWarnings("unchecked")
	public T checkPeriod(java.lang.Long value) {
		Object oldValue = this.checkPeriod;
		this.checkPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("checkPeriod", oldValue, value);
		return (T) this;
	}

	/**
	 * The confirmation-window-size to use for the connection used to forward
	 * messages to the target node.
	 */
	@ModelNodeBinding(detypedName = "confirmation-window-size")
	public Integer confirmationWindowSize() {
		return this.confirmationWindowSize;
	}

	/**
	 * The confirmation-window-size to use for the connection used to forward
	 * messages to the target node.
	 */
	@SuppressWarnings("unchecked")
	public T confirmationWindowSize(java.lang.Integer value) {
		Object oldValue = this.confirmationWindowSize;
		this.confirmationWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("confirmationWindowSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum time (in milliseconds) for which the connections used by the
	 * bridges are considered alive (in the absence of heartbeat).
	 */
	@ModelNodeBinding(detypedName = "connection-ttl")
	public Long connectionTtl() {
		return this.connectionTtl;
	}

	/**
	 * The maximum time (in milliseconds) for which the connections used by the
	 * bridges are considered alive (in the absence of heartbeat).
	 */
	@SuppressWarnings("unchecked")
	public T connectionTtl(java.lang.Long value) {
		Object oldValue = this.connectionTtl;
		this.connectionTtl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionTtl", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the discovery group used by this bridge. Must be undefined
	 * (null) if 'static-connectors' is defined.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The name of the discovery group used by this bridge. Must be undefined
	 * (null) if 'static-connectors' is defined.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(java.lang.String value) {
		Object oldValue = this.discoveryGroup;
		this.discoveryGroup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("discoveryGroup", oldValue, value);
		return (T) this;
	}

	/**
	 * An optional filter string. If specified then only messages which match
	 * the filter expression specified will be forwarded. The filter string
	 * follows the ActiveMQ filter expression syntax described in the ActiveMQ
	 * documentation.
	 */
	@ModelNodeBinding(detypedName = "filter")
	public String filter() {
		return this.filter;
	}

	/**
	 * An optional filter string. If specified then only messages which match
	 * the filter expression specified will be forwarded. The filter string
	 * follows the ActiveMQ filter expression syntax described in the ActiveMQ
	 * documentation.
	 */
	@SuppressWarnings("unchecked")
	public T filter(java.lang.String value) {
		Object oldValue = this.filter;
		this.filter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filter", oldValue, value);
		return (T) this;
	}

	/**
	 * The address on the target server that the message will be forwarded to.
	 * If a forwarding address is not specified then the original destination of
	 * the message will be retained.
	 */
	@ModelNodeBinding(detypedName = "forwarding-address")
	public String forwardingAddress() {
		return this.forwardingAddress;
	}

	/**
	 * The address on the target server that the message will be forwarded to.
	 * If a forwarding address is not specified then the original destination of
	 * the message will be retained.
	 */
	@SuppressWarnings("unchecked")
	public T forwardingAddress(java.lang.String value) {
		Object oldValue = this.forwardingAddress;
		this.forwardingAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("forwardingAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether or not this bridge should support high availability. True means
	 * it will connect to any available server in a cluster and support
	 * failover.
	 */
	@ModelNodeBinding(detypedName = "ha")
	public Boolean ha() {
		return this.ha;
	}

	/**
	 * Whether or not this bridge should support high availability. True means
	 * it will connect to any available server in a cluster and support
	 * failover.
	 */
	@SuppressWarnings("unchecked")
	public T ha(java.lang.Boolean value) {
		Object oldValue = this.ha;
		this.ha = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ha", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of attempts to connect initially with this bridge.
	 */
	@ModelNodeBinding(detypedName = "initial-connect-attempts")
	public Integer initialConnectAttempts() {
		return this.initialConnectAttempts;
	}

	/**
	 * The number of attempts to connect initially with this bridge.
	 */
	@SuppressWarnings("unchecked")
	public T initialConnectAttempts(java.lang.Integer value) {
		Object oldValue = this.initialConnectAttempts;
		this.initialConnectAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialConnectAttempts", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum interval of time used to retry connections
	 */
	@ModelNodeBinding(detypedName = "max-retry-interval")
	public Long maxRetryInterval() {
		return this.maxRetryInterval;
	}

	/**
	 * The maximum interval of time used to retry connections
	 */
	@SuppressWarnings("unchecked")
	public T maxRetryInterval(java.lang.Long value) {
		Object oldValue = this.maxRetryInterval;
		this.maxRetryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxRetryInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * The minimum size (in bytes) for a message before it is considered as a
	 * large message.
	 */
	@ModelNodeBinding(detypedName = "min-large-message-size")
	public Integer minLargeMessageSize() {
		return this.minLargeMessageSize;
	}

	/**
	 * The minimum size (in bytes) for a message before it is considered as a
	 * large message.
	 */
	@SuppressWarnings("unchecked")
	public T minLargeMessageSize(java.lang.Integer value) {
		Object oldValue = this.minLargeMessageSize;
		this.minLargeMessageSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minLargeMessageSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The password to use when creating the bridge connection to the remote
	 * server. If it is not specified the default cluster password specified by
	 * the cluster-password attribute in the root messaging subsystem resource
	 * will be used.
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * The password to use when creating the bridge connection to the remote
	 * server. If it is not specified the default cluster password specified by
	 * the cluster-password attribute in the root messaging subsystem resource
	 * will be used.
	 */
	@SuppressWarnings("unchecked")
	public T password(java.lang.String value) {
		Object oldValue = this.password;
		this.password = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("password", oldValue, value);
		return (T) this;
	}

	/**
	 * The unique name of the local queue that the bridge consumes from.
	 */
	@ModelNodeBinding(detypedName = "queue-name")
	public String queueName() {
		return this.queueName;
	}

	/**
	 * The unique name of the local queue that the bridge consumes from.
	 */
	@SuppressWarnings("unchecked")
	public T queueName(java.lang.String value) {
		Object oldValue = this.queueName;
		this.queueName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueName", oldValue, value);
		return (T) this;
	}

	/**
	 * The total number of reconnect attempts the bridge will make before giving
	 * up and shutting down. A value of -1 signifies an unlimited number of
	 * attempts.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The total number of reconnect attempts the bridge will make before giving
	 * up and shutting down. A value of -1 signifies an unlimited number of
	 * attempts.
	 */
	@SuppressWarnings("unchecked")
	public T reconnectAttempts(java.lang.Integer value) {
		Object oldValue = this.reconnectAttempts;
		this.reconnectAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reconnectAttempts", oldValue, value);
		return (T) this;
	}

	/**
	 * The total number of reconnect attempts on the same node the bridge will
	 * make before giving up and shutting down. A value of -1 signifies an
	 * unlimited number of attempts.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts-on-same-node")
	public Integer reconnectAttemptsOnSameNode() {
		return this.reconnectAttemptsOnSameNode;
	}

	/**
	 * The total number of reconnect attempts on the same node the bridge will
	 * make before giving up and shutting down. A value of -1 signifies an
	 * unlimited number of attempts.
	 */
	@SuppressWarnings("unchecked")
	public T reconnectAttemptsOnSameNode(java.lang.Integer value) {
		Object oldValue = this.reconnectAttemptsOnSameNode;
		this.reconnectAttemptsOnSameNode = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reconnectAttemptsOnSameNode",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The period in milliseconds between subsequent reconnection attempts, if
	 * the connection to the target server has failed.
	 */
	@ModelNodeBinding(detypedName = "retry-interval")
	public Long retryInterval() {
		return this.retryInterval;
	}

	/**
	 * The period in milliseconds between subsequent reconnection attempts, if
	 * the connection to the target server has failed.
	 */
	@SuppressWarnings("unchecked")
	public T retryInterval(java.lang.Long value) {
		Object oldValue = this.retryInterval;
		this.retryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("retryInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * A multiplier to apply to the time since the last retry to compute the
	 * time to the next retry. This allows you to implement an exponential
	 * backoff between retry attempts.
	 */
	@ModelNodeBinding(detypedName = "retry-interval-multiplier")
	public BigDecimal retryIntervalMultiplier() {
		return this.retryIntervalMultiplier;
	}

	/**
	 * A multiplier to apply to the time since the last retry to compute the
	 * time to the next retry. This allows you to implement an exponential
	 * backoff between retry attempts.
	 */
	@SuppressWarnings("unchecked")
	public T retryIntervalMultiplier(java.math.BigDecimal value) {
		Object oldValue = this.retryIntervalMultiplier;
		this.retryIntervalMultiplier = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("retryIntervalMultiplier", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Whether the bridge is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether the bridge is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(java.lang.Boolean value) {
		Object oldValue = this.started;
		this.started = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("started", oldValue, value);
		return (T) this;
	}

	/**
	 * A list of names of statically defined connectors used by this bridge.
	 * Must be undefined (null) if 'discovery-group-name' is defined.
	 */
	@ModelNodeBinding(detypedName = "static-connectors")
	public List<String> staticConnectors() {
		return this.staticConnectors;
	}

	/**
	 * A list of names of statically defined connectors used by this bridge.
	 * Must be undefined (null) if 'discovery-group-name' is defined.
	 */
	@SuppressWarnings("unchecked")
	public T staticConnectors(java.util.List<String> value) {
		Object oldValue = this.staticConnectors;
		this.staticConnectors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("staticConnectors", oldValue, value);
		return (T) this;
	}

	/**
	 * A list of names of statically defined connectors used by this bridge.
	 * Must be undefined (null) if 'discovery-group-name' is defined.
	 */
	@SuppressWarnings("unchecked")
	public T staticConnector(String value) {
		if (this.staticConnectors == null) {
			this.staticConnectors = new java.util.ArrayList<>();
		}
		this.staticConnectors.add(value);
		return (T) this;
	}

	/**
	 * A list of names of statically defined connectors used by this bridge.
	 * Must be undefined (null) if 'discovery-group-name' is defined.
	 */
	@SuppressWarnings("unchecked")
	public T staticConnectors(String... args) {
		staticConnectors(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The name of a user-defined class which implements the
	 * org.apache.activemq.artemis.core.server.cluster.Transformer interface.
	 */
	@ModelNodeBinding(detypedName = "transformer-class-name")
	public String transformerClassName() {
		return this.transformerClassName;
	}

	/**
	 * The name of a user-defined class which implements the
	 * org.apache.activemq.artemis.core.server.cluster.Transformer interface.
	 */
	@SuppressWarnings("unchecked")
	public T transformerClassName(java.lang.String value) {
		Object oldValue = this.transformerClassName;
		this.transformerClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transformerClassName", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the bridge will automatically insert a duplicate id property into
	 * each message that it forwards.
	 */
	@ModelNodeBinding(detypedName = "use-duplicate-detection")
	public Boolean useDuplicateDetection() {
		return this.useDuplicateDetection;
	}

	/**
	 * Whether the bridge will automatically insert a duplicate id property into
	 * each message that it forwards.
	 */
	@SuppressWarnings("unchecked")
	public T useDuplicateDetection(java.lang.Boolean value) {
		Object oldValue = this.useDuplicateDetection;
		this.useDuplicateDetection = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useDuplicateDetection", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The user name to use when creating the bridge connection to the remote
	 * server. If it is not specified the default cluster user specified by the
	 * cluster-user attribute in the root messaging subsystem resource will be
	 * used.
	 */
	@ModelNodeBinding(detypedName = "user")
	public String user() {
		return this.user;
	}

	/**
	 * The user name to use when creating the bridge connection to the remote
	 * server. If it is not specified the default cluster user specified by the
	 * cluster-user attribute in the root messaging subsystem resource will be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T user(java.lang.String value) {
		Object oldValue = this.user;
		this.user = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("user", oldValue, value);
		return (T) this;
	}
}