package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Session persistence sessions
 */
@Address("/subsystem=undertow/servlet-container=*/setting=persistent-sessions")
@ResourceType("setting")
@Implicit
public class PersistentSessionsSetting<T extends PersistentSessionsSetting<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private String path;
	private String relativeTo;

	public PersistentSessionsSetting() {
		super();
		this.key = "persistent-sessions";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The path to the persistent session data directory. If this is null
	 * sessions will be stored in memory
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The path to the persistent session data directory. If this is null
	 * sessions will be stored in memory
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The directory the path is relative to
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The directory the path is relative to
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}
}