package org.wildfly.swarm.config.webservices;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.webservices.HandlerConsumer;
import org.wildfly.swarm.config.webservices.HandlerSupplier;
import org.wildfly.swarm.config.webservices.Handler;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Endpoint configuration POST handler chain
 */
@Addresses({"/subsystem=webservices/client-config=*/post-handler-chain=*",
		"/subsystem=webservices/endpoint-config=*/post-handler-chain=*"})
@ResourceType("post-handler-chain")
public class PostHandlerChain<T extends PostHandlerChain<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private PostHandlerChainResources subresources = new PostHandlerChainResources();
	private String protocolBindings;

	public PostHandlerChain(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public PostHandlerChainResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Handler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Handler objects.
	 */
	@SuppressWarnings("unchecked")
	public T handlers(java.util.List<Handler> value) {
		this.subresources.handlers = value;
		return (T) this;
	}

	/**
	 * Add the Handler object to the list of subresources
	 * 
	 * @param value
	 *            The Handler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T handler(Handler value) {
		this.subresources.handlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Handler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Handler resource
	 * @param config
	 *            The HandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T handler(java.lang.String childKey, HandlerConsumer consumer) {
		Handler<? extends Handler> child = new Handler<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		handler(child);
		return (T) this;
	}

	/**
	 * Create and configure a Handler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Handler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T handler(java.lang.String childKey) {
		handler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Handler object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T handler(HandlerSupplier supplier) {
		handler(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for PostHandlerChain
	 */
	public static class PostHandlerChainResources {
		/**
		 * Endpoint handler
		 */
		@SubresourceInfo("handler")
		private List<Handler> handlers = new java.util.ArrayList<>();

		/**
		 * Get the list of Handler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Handler> handlers() {
			return this.handlers;
		}

		public Handler handler(java.lang.String key) {
			return this.handlers.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}

	/**
	 * Protocol binding
	 */
	@ModelNodeBinding(detypedName = "protocol-bindings")
	public String protocolBindings() {
		return this.protocolBindings;
	}

	/**
	 * Protocol binding
	 */
	@SuppressWarnings("unchecked")
	public T protocolBindings(java.lang.String value) {
		Object oldValue = this.protocolBindings;
		this.protocolBindings = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocolBindings", oldValue, value);
		return (T) this;
	}
}