/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.batch.jberet.InMemoryJobRepository;
import org.wildfly.swarm.config.batch.jberet.InMemoryJobRepositoryConsumer;
import org.wildfly.swarm.config.batch.jberet.InMemoryJobRepositorySupplier;
import org.wildfly.swarm.config.batch.jberet.JDBCJobRepository;
import org.wildfly.swarm.config.batch.jberet.JDBCJobRepositoryConsumer;
import org.wildfly.swarm.config.batch.jberet.JDBCJobRepositorySupplier;
import org.wildfly.swarm.config.batch.jberet.ThreadFactory;
import org.wildfly.swarm.config.batch.jberet.ThreadFactoryConsumer;
import org.wildfly.swarm.config.batch.jberet.ThreadFactorySupplier;
import org.wildfly.swarm.config.batch.jberet.ThreadPool;
import org.wildfly.swarm.config.batch.jberet.ThreadPoolConsumer;
import org.wildfly.swarm.config.batch.jberet.ThreadPoolSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=batch-jberet")
@ResourceType(value="subsystem")
@Implicit
public class BatchJBeret<T extends BatchJBeret<T>>
extends HashMap
implements Keyed {
    private String key = "batch-jberet";
    private PropertyChangeSupport pcs;
    private BatchJBeretResources subresources = new BatchJBeretResources();
    private Boolean restartJobsOnResume;
    private String defaultJobRepository;
    private String defaultThreadPool;

    public BatchJBeret() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public BatchJBeretResources subresources() {
        return this.subresources;
    }

    public T jdbcJobRepositories(List<JDBCJobRepository> value) {
        this.subresources.jdbcJobRepositories = value;
        return (T)this;
    }

    public T jdbcJobRepository(JDBCJobRepository value) {
        this.subresources.jdbcJobRepositories.add(value);
        return (T)this;
    }

    public T jdbcJobRepository(String childKey, JDBCJobRepositoryConsumer consumer) {
        JDBCJobRepository child = new JDBCJobRepository(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jdbcJobRepository(child);
        return (T)this;
    }

    public T jdbcJobRepository(String childKey) {
        this.jdbcJobRepository(childKey, null);
        return (T)this;
    }

    public T jdbcJobRepository(JDBCJobRepositorySupplier supplier) {
        this.jdbcJobRepository(supplier.get());
        return (T)this;
    }

    public T threadFactories(List<ThreadFactory> value) {
        this.subresources.threadFactories = value;
        return (T)this;
    }

    public T threadFactory(ThreadFactory value) {
        this.subresources.threadFactories.add(value);
        return (T)this;
    }

    public T threadFactory(String childKey, ThreadFactoryConsumer consumer) {
        ThreadFactory child = new ThreadFactory(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.threadFactory(child);
        return (T)this;
    }

    public T threadFactory(String childKey) {
        this.threadFactory(childKey, null);
        return (T)this;
    }

    public T threadFactory(ThreadFactorySupplier supplier) {
        this.threadFactory(supplier.get());
        return (T)this;
    }

    public T threadPools(List<ThreadPool> value) {
        this.subresources.threadPools = value;
        return (T)this;
    }

    public T threadPool(ThreadPool value) {
        this.subresources.threadPools.add(value);
        return (T)this;
    }

    public T threadPool(String childKey, ThreadPoolConsumer consumer) {
        ThreadPool child = new ThreadPool(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.threadPool(child);
        return (T)this;
    }

    public T threadPool(String childKey) {
        this.threadPool(childKey, null);
        return (T)this;
    }

    public T threadPool(ThreadPoolSupplier supplier) {
        this.threadPool(supplier.get());
        return (T)this;
    }

    public T inMemoryJobRepositories(List<InMemoryJobRepository> value) {
        this.subresources.inMemoryJobRepositories = value;
        return (T)this;
    }

    public T inMemoryJobRepository(InMemoryJobRepository value) {
        this.subresources.inMemoryJobRepositories.add(value);
        return (T)this;
    }

    public T inMemoryJobRepository(String childKey, InMemoryJobRepositoryConsumer consumer) {
        InMemoryJobRepository child = new InMemoryJobRepository(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.inMemoryJobRepository(child);
        return (T)this;
    }

    public T inMemoryJobRepository(String childKey) {
        this.inMemoryJobRepository(childKey, null);
        return (T)this;
    }

    public T inMemoryJobRepository(InMemoryJobRepositorySupplier supplier) {
        this.inMemoryJobRepository(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="restart-jobs-on-resume")
    public Boolean restartJobsOnResume() {
        return this.restartJobsOnResume;
    }

    public T restartJobsOnResume(Boolean value) {
        Boolean oldValue = this.restartJobsOnResume;
        this.restartJobsOnResume = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("restartJobsOnResume", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-job-repository")
    public String defaultJobRepository() {
        return this.defaultJobRepository;
    }

    public T defaultJobRepository(String value) {
        String oldValue = this.defaultJobRepository;
        this.defaultJobRepository = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultJobRepository", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-thread-pool")
    public String defaultThreadPool() {
        return this.defaultThreadPool;
    }

    public T defaultThreadPool(String value) {
        String oldValue = this.defaultThreadPool;
        this.defaultThreadPool = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultThreadPool", oldValue, value);
        }
        return (T)this;
    }

    public static class BatchJBeretResources {
        @SubresourceInfo(value="jdbcJobRepository")
        private List<JDBCJobRepository> jdbcJobRepositories = new ArrayList<JDBCJobRepository>();
        @SubresourceInfo(value="threadFactory")
        private List<ThreadFactory> threadFactories = new ArrayList<ThreadFactory>();
        @SubresourceInfo(value="threadPool")
        private List<ThreadPool> threadPools = new ArrayList<ThreadPool>();
        @SubresourceInfo(value="inMemoryJobRepository")
        private List<InMemoryJobRepository> inMemoryJobRepositories = new ArrayList<InMemoryJobRepository>();

        @Subresource
        public List<JDBCJobRepository> jdbcJobRepositories() {
            return this.jdbcJobRepositories;
        }

        public JDBCJobRepository jdbcJobRepository(String key) {
            return this.jdbcJobRepositories.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ThreadFactory> threadFactories() {
            return this.threadFactories;
        }

        public ThreadFactory threadFactory(String key) {
            return this.threadFactories.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ThreadPool> threadPools() {
            return this.threadPools;
        }

        public ThreadPool threadPool(String key) {
            return this.threadPools.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<InMemoryJobRepository> inMemoryJobRepositories() {
            return this.inMemoryJobRepositories;
        }

        public InMemoryJobRepository inMemoryJobRepository(String key) {
            return this.inMemoryJobRepositories.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

