/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.jgroups;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.jgroups.Protocol;
import org.wildfly.swarm.config.jgroups.ProtocolConsumer;
import org.wildfly.swarm.config.jgroups.ProtocolSupplier;
import org.wildfly.swarm.config.jgroups.stack.Transport;
import org.wildfly.swarm.config.jgroups.stack.TransportConsumer;
import org.wildfly.swarm.config.jgroups.stack.TransportSupplier;
import org.wildfly.swarm.config.jgroups.stack.relay.RELAY2;
import org.wildfly.swarm.config.jgroups.stack.relay.RELAY2Consumer;
import org.wildfly.swarm.config.jgroups.stack.relay.RELAY2Supplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=jgroups/stack=*")
@ResourceType(value="stack")
public class Stack<T extends Stack<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private StackResources subresources = new StackResources();

    public Stack(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public StackResources subresources() {
        return this.subresources;
    }

    public T protocols(List<Protocol> value) {
        this.subresources.protocols = value;
        return (T)this;
    }

    public T protocol(Protocol value) {
        this.subresources.protocols.add(value);
        return (T)this;
    }

    public T protocol(String childKey, ProtocolConsumer consumer) {
        Protocol child = new Protocol(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.protocol(child);
        return (T)this;
    }

    public T protocol(String childKey) {
        this.protocol(childKey, null);
        return (T)this;
    }

    public T protocol(ProtocolSupplier supplier) {
        this.protocol(supplier.get());
        return (T)this;
    }

    public T transports(List<Transport> value) {
        this.subresources.transports = value;
        return (T)this;
    }

    public T transport(Transport value) {
        this.subresources.transports.add(value);
        return (T)this;
    }

    public T transport(String childKey, TransportConsumer consumer) {
        Transport child = new Transport(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.transport(child);
        return (T)this;
    }

    public T transport(String childKey) {
        this.transport(childKey, null);
        return (T)this;
    }

    public T transport(TransportSupplier supplier) {
        this.transport(supplier.get());
        return (T)this;
    }

    public T RELAY2(RELAY2 value) {
        this.subresources.RELAY2 = value;
        return (T)this;
    }

    public T RELAY2(RELAY2Consumer consumer) {
        RELAY2 child = new RELAY2();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.RELAY2 = child;
        return (T)this;
    }

    public T RELAY2() {
        RELAY2 child = new RELAY2();
        this.subresources.RELAY2 = child;
        return (T)this;
    }

    public T RELAY2(RELAY2Supplier supplier) {
        this.subresources.RELAY2 = supplier.get();
        return (T)this;
    }

    public static class StackResources {
        @SubresourceInfo(value="protocol")
        private List<Protocol> protocols = new ArrayList<Protocol>();
        @SubresourceInfo(value="transport")
        private List<Transport> transports = new ArrayList<Transport>();
        private RELAY2 RELAY2;

        @Subresource
        public List<Protocol> protocols() {
            return this.protocols;
        }

        public Protocol protocol(String key) {
            return this.protocols.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Transport> transports() {
            return this.transports;
        }

        public Transport transport(String key) {
            return this.transports.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public RELAY2 RELAY2() {
            return this.RELAY2;
        }
    }
}

