/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.management.service.ActiveOperation;
import org.wildfly.swarm.config.management.service.ActiveOperationConsumer;
import org.wildfly.swarm.config.management.service.ActiveOperationSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/core-service=management/service=management-operations")
@ResourceType(value="service")
@Implicit
public class ManagementOperationsService<T extends ManagementOperationsService<T>>
extends HashMap
implements Keyed {
    private String key = "management-operations";
    private PropertyChangeSupport pcs;
    private ManagementOperationsServiceResources subresources = new ManagementOperationsServiceResources();

    public ManagementOperationsService() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ManagementOperationsServiceResources subresources() {
        return this.subresources;
    }

    public T activeOperations(List<ActiveOperation> value) {
        this.subresources.activeOperations = value;
        return (T)this;
    }

    public T activeOperation(ActiveOperation value) {
        this.subresources.activeOperations.add(value);
        return (T)this;
    }

    public T activeOperation(String childKey, ActiveOperationConsumer consumer) {
        ActiveOperation child = new ActiveOperation(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.activeOperation(child);
        return (T)this;
    }

    public T activeOperation(String childKey) {
        this.activeOperation(childKey, null);
        return (T)this;
    }

    public T activeOperation(ActiveOperationSupplier supplier) {
        this.activeOperation(supplier.get());
        return (T)this;
    }

    public static class ManagementOperationsServiceResources {
        @SubresourceInfo(value="activeOperation")
        private List<ActiveOperation> activeOperations = new ArrayList<ActiveOperation>();

        @Subresource
        public List<ActiveOperation> activeOperations() {
            return this.activeOperations;
        }

        public ActiveOperation activeOperation(String key) {
            return this.activeOperations.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

