package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * The options that will be used during the EJB remote channel creation
 */
@Addresses({
		"/subsystem=ejb3/remoting-profile=*/remoting-ejb-receiver=*/channel-creation-options=*",
		"/subsystem=ejb3/service=remote/channel-creation-options=*"})
@ResourceType("channel-creation-options")
public class ChannelCreationOptions<T extends ChannelCreationOptions<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private Type type;
	private String value;

	public ChannelCreationOptions(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Type {
		REMOTING("remoting"), XNIO("xnio");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Type(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The type of the channel creation option
	 */
	@ModelNodeBinding(detypedName = "type")
	public Type type() {
		return this.type;
	}

	/**
	 * The type of the channel creation option
	 */
	@SuppressWarnings("unchecked")
	public T type(Type value) {
		Object oldValue = this.type;
		this.type = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("type", oldValue, value);
		return (T) this;
	}

	/**
	 * The value for the EJB remote channel creation option
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The value for the EJB remote channel creation option
	 */
	@SuppressWarnings("unchecked")
	public T value(java.lang.String value) {
		Object oldValue = this.value;
		this.value = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("value", oldValue, value);
		return (T) this;
	}
}