package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.MasterConfiguration;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.MasterConfigurationConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.MasterConfigurationSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.SlaveConfiguration;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.SlaveConfigurationConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.SlaveConfigurationSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A messaging resource that allows you to configure High Availability for the
 * ActiveMQ server (the value of ha-policy can be live-only, replication-master,
 * replication-slave, or replication-colocated).
 */
@Address("/subsystem=messaging-activemq/server=*/ha-policy=replication-colocated")
@ResourceType("ha-policy")
@Implicit
public class ReplicationColocatedHAPolicy<T extends ReplicationColocatedHAPolicy<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ReplicationColocatedHAPolicyResources subresources = new ReplicationColocatedHAPolicyResources();
	private Integer backupPortOffset;
	private Integer backupRequestRetries;
	private Long backupRequestRetryInterval;
	private List<String> excludedConnectors;
	private Integer maxBackups;
	private Boolean requestBackup;

	public ReplicationColocatedHAPolicy() {
		super();
		this.key = "replication-colocated";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ReplicationColocatedHAPolicyResources subresources() {
		return this.subresources;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T masterConfiguration(MasterConfiguration value) {
		this.subresources.masterConfiguration = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T masterConfiguration(MasterConfigurationConsumer consumer) {
		MasterConfiguration<? extends MasterConfiguration> child = new MasterConfiguration<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.masterConfiguration = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T masterConfiguration() {
		MasterConfiguration<? extends MasterConfiguration> child = new MasterConfiguration<>();
		this.subresources.masterConfiguration = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T masterConfiguration(MasterConfigurationSupplier supplier) {
		this.subresources.masterConfiguration = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T slaveConfiguration(SlaveConfiguration value) {
		this.subresources.slaveConfiguration = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T slaveConfiguration(SlaveConfigurationConsumer consumer) {
		SlaveConfiguration<? extends SlaveConfiguration> child = new SlaveConfiguration<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.slaveConfiguration = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T slaveConfiguration() {
		SlaveConfiguration<? extends SlaveConfiguration> child = new SlaveConfiguration<>();
		this.subresources.slaveConfiguration = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T slaveConfiguration(SlaveConfigurationSupplier supplier) {
		this.subresources.slaveConfiguration = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for ReplicationColocatedHAPolicy
	 */
	public static class ReplicationColocatedHAPolicyResources {
		private MasterConfiguration masterConfiguration;
		private SlaveConfiguration slaveConfiguration;

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public MasterConfiguration masterConfiguration() {
			return this.masterConfiguration;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public SlaveConfiguration slaveConfiguration() {
			return this.slaveConfiguration;
		}
	}

	/**
	 * The offset to use for the Connectors and Acceptors when creating a new
	 * backup server.
	 */
	@ModelNodeBinding(detypedName = "backup-port-offset")
	public Integer backupPortOffset() {
		return this.backupPortOffset;
	}

	/**
	 * The offset to use for the Connectors and Acceptors when creating a new
	 * backup server.
	 */
	@SuppressWarnings("unchecked")
	public T backupPortOffset(java.lang.Integer value) {
		Object oldValue = this.backupPortOffset;
		this.backupPortOffset = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("backupPortOffset", oldValue, value);
		return (T) this;
	}

	/**
	 * How many times the live server will try to request a backup, -1 means for
	 * ever.
	 */
	@ModelNodeBinding(detypedName = "backup-request-retries")
	public Integer backupRequestRetries() {
		return this.backupRequestRetries;
	}

	/**
	 * How many times the live server will try to request a backup, -1 means for
	 * ever.
	 */
	@SuppressWarnings("unchecked")
	public T backupRequestRetries(java.lang.Integer value) {
		Object oldValue = this.backupRequestRetries;
		this.backupRequestRetries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("backupRequestRetries", oldValue, value);
		return (T) this;
	}

	/**
	 * How long (in ms) to wait for retries between attempts to request a backup
	 * server.
	 */
	@ModelNodeBinding(detypedName = "backup-request-retry-interval")
	public Long backupRequestRetryInterval() {
		return this.backupRequestRetryInterval;
	}

	/**
	 * How long (in ms) to wait for retries between attempts to request a backup
	 * server.
	 */
	@SuppressWarnings("unchecked")
	public T backupRequestRetryInterval(java.lang.Long value) {
		Object oldValue = this.backupRequestRetryInterval;
		this.backupRequestRetryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("backupRequestRetryInterval", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The connectors that must not have their port offset.
	 */
	@ModelNodeBinding(detypedName = "excluded-connectors")
	public List<String> excludedConnectors() {
		return this.excludedConnectors;
	}

	/**
	 * The connectors that must not have their port offset.
	 */
	@SuppressWarnings("unchecked")
	public T excludedConnectors(java.util.List<String> value) {
		Object oldValue = this.excludedConnectors;
		this.excludedConnectors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("excludedConnectors", oldValue, value);
		return (T) this;
	}

	/**
	 * The connectors that must not have their port offset.
	 */
	@SuppressWarnings("unchecked")
	public T excludedConnector(String value) {
		if (this.excludedConnectors == null) {
			this.excludedConnectors = new java.util.ArrayList<>();
		}
		this.excludedConnectors.add(value);
		return (T) this;
	}

	/**
	 * The connectors that must not have their port offset.
	 */
	@SuppressWarnings("unchecked")
	public T excludedConnectors(String... args) {
		excludedConnectors(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Whether or not this live server will accept backup requests from other
	 * live servers.
	 */
	@ModelNodeBinding(detypedName = "max-backups")
	public Integer maxBackups() {
		return this.maxBackups;
	}

	/**
	 * Whether or not this live server will accept backup requests from other
	 * live servers.
	 */
	@SuppressWarnings("unchecked")
	public T maxBackups(java.lang.Integer value) {
		Object oldValue = this.maxBackups;
		this.maxBackups = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxBackups", oldValue, value);
		return (T) this;
	}

	/**
	 * If true then the server will request a backup on another node.
	 */
	@ModelNodeBinding(detypedName = "request-backup")
	public Boolean requestBackup() {
		return this.requestBackup;
	}

	/**
	 * If true then the server will request a backup on another node.
	 */
	@SuppressWarnings("unchecked")
	public T requestBackup(java.lang.Boolean value) {
		Object oldValue = this.requestBackup;
		this.requestBackup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("requestBackup", oldValue, value);
		return (T) this;
	}
}