package org.wildfly.swarm.config.modcluster;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationSsl;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationSslConsumer;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationSslSupplier;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationDynamicLoadProvider;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationDynamicLoadProviderConsumer;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationDynamicLoadProviderSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * The common modcluster configuration.
 */
@Address("/subsystem=modcluster/mod-cluster-config=configuration")
@ResourceType("mod-cluster-config")
@Implicit
public class ConfigurationModClusterConfig<T extends ConfigurationModClusterConfig<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ConfigurationModClusterConfigResources subresources = new ConfigurationModClusterConfigResources();
	private Boolean advertise;
	private String advertiseSecurityKey;
	private String advertiseSocket;
	private Boolean autoEnableContexts;
	private String balancer;
	private String connector;
	private String excludedContexts;
	private Boolean flushPackets;
	private Integer flushWait;
	private String loadBalancingGroup;
	private Integer maxAttempts;
	private Integer nodeTimeout;
	private Integer ping;
	private List<String> proxies;
	private String proxyUrl;
	private SessionDrainingStrategy sessionDrainingStrategy;
	private Integer simpleLoadProvider;
	private Integer smax;
	private Integer socketTimeout;
	private Integer statusInterval;
	private Boolean stickySession;
	private Boolean stickySessionForce;
	private Boolean stickySessionRemove;
	private Integer stopContextTimeout;
	private Integer ttl;
	private Integer workerTimeout;

	public ConfigurationModClusterConfig() {
		super();
		this.key = "configuration";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ConfigurationModClusterConfigResources subresources() {
		return this.subresources;
	}

	/**
	 * The SSL configuration to client MCMP logic.
	 */
	@SuppressWarnings("unchecked")
	public T configurationSsl(ConfigurationSsl value) {
		this.subresources.configurationSsl = value;
		return (T) this;
	}

	/**
	 * The SSL configuration to client MCMP logic.
	 */
	@SuppressWarnings("unchecked")
	public T configurationSsl(ConfigurationSslConsumer consumer) {
		ConfigurationSsl<? extends ConfigurationSsl> child = new ConfigurationSsl<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.configurationSsl = child;
		return (T) this;
	}

	/**
	 * The SSL configuration to client MCMP logic.
	 */
	@SuppressWarnings("unchecked")
	public T configurationSsl() {
		ConfigurationSsl<? extends ConfigurationSsl> child = new ConfigurationSsl<>();
		this.subresources.configurationSsl = child;
		return (T) this;
	}

	/**
	 * The SSL configuration to client MCMP logic.
	 */
	@SuppressWarnings("unchecked")
	public T configurationSsl(ConfigurationSslSupplier supplier) {
		this.subresources.configurationSsl = supplier.get();
		return (T) this;
	}

	/**
	 * Dynamic load provider
	 */
	@SuppressWarnings("unchecked")
	public T configurationDynamicLoadProvider(
			ConfigurationDynamicLoadProvider value) {
		this.subresources.configurationDynamicLoadProvider = value;
		return (T) this;
	}

	/**
	 * Dynamic load provider
	 */
	@SuppressWarnings("unchecked")
	public T configurationDynamicLoadProvider(
			ConfigurationDynamicLoadProviderConsumer consumer) {
		ConfigurationDynamicLoadProvider<? extends ConfigurationDynamicLoadProvider> child = new ConfigurationDynamicLoadProvider<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.configurationDynamicLoadProvider = child;
		return (T) this;
	}

	/**
	 * Dynamic load provider
	 */
	@SuppressWarnings("unchecked")
	public T configurationDynamicLoadProvider() {
		ConfigurationDynamicLoadProvider<? extends ConfigurationDynamicLoadProvider> child = new ConfigurationDynamicLoadProvider<>();
		this.subresources.configurationDynamicLoadProvider = child;
		return (T) this;
	}

	/**
	 * Dynamic load provider
	 */
	@SuppressWarnings("unchecked")
	public T configurationDynamicLoadProvider(
			ConfigurationDynamicLoadProviderSupplier supplier) {
		this.subresources.configurationDynamicLoadProvider = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for ConfigurationModClusterConfig
	 */
	public static class ConfigurationModClusterConfigResources {
		private ConfigurationSsl configurationSsl;
		private ConfigurationDynamicLoadProvider configurationDynamicLoadProvider;

		/**
		 * The SSL configuration to client MCMP logic.
		 */
		@Subresource
		public ConfigurationSsl configurationSsl() {
			return this.configurationSsl;
		}

		/**
		 * Dynamic load provider
		 */
		@Subresource
		public ConfigurationDynamicLoadProvider configurationDynamicLoadProvider() {
			return this.configurationDynamicLoadProvider;
		}
	}

	public static enum SessionDrainingStrategy {
		DEFAULT("DEFAULT"), ALWAYS("ALWAYS"), NEVER("NEVER");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		SessionDrainingStrategy(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Use Advertise logic or not.
	 */
	@ModelNodeBinding(detypedName = "advertise")
	public Boolean advertise() {
		return this.advertise;
	}

	/**
	 * Use Advertise logic or not.
	 */
	@SuppressWarnings("unchecked")
	public T advertise(java.lang.Boolean value) {
		Object oldValue = this.advertise;
		this.advertise = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("advertise", oldValue, value);
		return (T) this;
	}

	/**
	 * String containing the security key for the Advertise logic.
	 */
	@ModelNodeBinding(detypedName = "advertise-security-key")
	public String advertiseSecurityKey() {
		return this.advertiseSecurityKey;
	}

	/**
	 * String containing the security key for the Advertise logic.
	 */
	@SuppressWarnings("unchecked")
	public T advertiseSecurityKey(java.lang.String value) {
		Object oldValue = this.advertiseSecurityKey;
		this.advertiseSecurityKey = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("advertiseSecurityKey", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of Socket binding to use for the Advertise socket.
	 */
	@ModelNodeBinding(detypedName = "advertise-socket")
	public String advertiseSocket() {
		return this.advertiseSocket;
	}

	/**
	 * Name of Socket binding to use for the Advertise socket.
	 */
	@SuppressWarnings("unchecked")
	public T advertiseSocket(java.lang.String value) {
		Object oldValue = this.advertiseSocket;
		this.advertiseSocket = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("advertiseSocket", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable contexts even if disabled in mod_cluster_manager (httpd).
	 */
	@ModelNodeBinding(detypedName = "auto-enable-contexts")
	public Boolean autoEnableContexts() {
		return this.autoEnableContexts;
	}

	/**
	 * Enable contexts even if disabled in mod_cluster_manager (httpd).
	 */
	@SuppressWarnings("unchecked")
	public T autoEnableContexts(java.lang.Boolean value) {
		Object oldValue = this.autoEnableContexts;
		this.autoEnableContexts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoEnableContexts", oldValue, value);
		return (T) this;
	}

	/**
	 * The balancer name.
	 */
	@ModelNodeBinding(detypedName = "balancer")
	public String balancer() {
		return this.balancer;
	}

	/**
	 * The balancer name.
	 */
	@SuppressWarnings("unchecked")
	public T balancer(java.lang.String value) {
		Object oldValue = this.balancer;
		this.balancer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("balancer", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of Undertow listener that mod_cluster reverse proxy will connect
	 * to.
	 */
	@ModelNodeBinding(detypedName = "connector")
	public String connector() {
		return this.connector;
	}

	/**
	 * The name of Undertow listener that mod_cluster reverse proxy will connect
	 * to.
	 */
	@SuppressWarnings("unchecked")
	public T connector(java.lang.String value) {
		Object oldValue = this.connector;
		this.connector = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connector", oldValue, value);
		return (T) this;
	}

	/**
	 * List of contexts mod_cluster should ignore, Format String separated with
	 * commas.
	 */
	@ModelNodeBinding(detypedName = "excluded-contexts")
	public String excludedContexts() {
		return this.excludedContexts;
	}

	/**
	 * List of contexts mod_cluster should ignore, Format String separated with
	 * commas.
	 */
	@SuppressWarnings("unchecked")
	public T excludedContexts(java.lang.String value) {
		Object oldValue = this.excludedContexts;
		this.excludedContexts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("excludedContexts", oldValue, value);
		return (T) this;
	}

	/**
	 * Enables/disables packet flushing in httpd.
	 */
	@ModelNodeBinding(detypedName = "flush-packets")
	public Boolean flushPackets() {
		return this.flushPackets;
	}

	/**
	 * Enables/disables packet flushing in httpd.
	 */
	@SuppressWarnings("unchecked")
	public T flushPackets(java.lang.Boolean value) {
		Object oldValue = this.flushPackets;
		this.flushPackets = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("flushPackets", oldValue, value);
		return (T) this;
	}

	/**
	 * Time to wait before flushing packets in httpd.
	 */
	@ModelNodeBinding(detypedName = "flush-wait")
	public Integer flushWait() {
		return this.flushWait;
	}

	/**
	 * Time to wait before flushing packets in httpd.
	 */
	@SuppressWarnings("unchecked")
	public T flushWait(java.lang.Integer value) {
		Object oldValue = this.flushWait;
		this.flushWait = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("flushWait", oldValue, value);
		return (T) this;
	}

	/**
	 * loadBalancingGroup name.
	 */
	@ModelNodeBinding(detypedName = "load-balancing-group")
	public String loadBalancingGroup() {
		return this.loadBalancingGroup;
	}

	/**
	 * loadBalancingGroup name.
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroup(java.lang.String value) {
		Object oldValue = this.loadBalancingGroup;
		this.loadBalancingGroup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("loadBalancingGroup", oldValue, value);
		return (T) this;
	}

	/**
	 * Max attempts to process an idempotent request.
	 */
	@ModelNodeBinding(detypedName = "max-attempts")
	public Integer maxAttempts() {
		return this.maxAttempts;
	}

	/**
	 * Max attempts to process an idempotent request.
	 */
	@SuppressWarnings("unchecked")
	public T maxAttempts(java.lang.Integer value) {
		Object oldValue = this.maxAttempts;
		this.maxAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxAttempts", oldValue, value);
		return (T) this;
	}

	/**
	 * Timeout (in seconds) for proxy connections to a node.
	 */
	@ModelNodeBinding(detypedName = "node-timeout")
	public Integer nodeTimeout() {
		return this.nodeTimeout;
	}

	/**
	 * Timeout (in seconds) for proxy connections to a node.
	 */
	@SuppressWarnings("unchecked")
	public T nodeTimeout(java.lang.Integer value) {
		Object oldValue = this.nodeTimeout;
		this.nodeTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nodeTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Time (in seconds) in which to wait for a pong answer to a ping.
	 */
	@ModelNodeBinding(detypedName = "ping")
	public Integer ping() {
		return this.ping;
	}

	/**
	 * Time (in seconds) in which to wait for a pong answer to a ping.
	 */
	@SuppressWarnings("unchecked")
	public T ping(java.lang.Integer value) {
		Object oldValue = this.ping;
		this.ping = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ping", oldValue, value);
		return (T) this;
	}

	/**
	 * List of proxies for mod_cluster to register with defined by
	 * outbound-socket-binding in socket-binding-group.
	 */
	@ModelNodeBinding(detypedName = "proxies")
	public List<String> proxies() {
		return this.proxies;
	}

	/**
	 * List of proxies for mod_cluster to register with defined by
	 * outbound-socket-binding in socket-binding-group.
	 */
	@SuppressWarnings("unchecked")
	public T proxies(java.util.List<String> value) {
		Object oldValue = this.proxies;
		this.proxies = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("proxies", oldValue, value);
		return (T) this;
	}

	/**
	 * List of proxies for mod_cluster to register with defined by
	 * outbound-socket-binding in socket-binding-group.
	 */
	@SuppressWarnings("unchecked")
	public T proxy(String value) {
		if (this.proxies == null) {
			this.proxies = new java.util.ArrayList<>();
		}
		this.proxies.add(value);
		return (T) this;
	}

	/**
	 * List of proxies for mod_cluster to register with defined by
	 * outbound-socket-binding in socket-binding-group.
	 */
	@SuppressWarnings("unchecked")
	public T proxies(String... args) {
		proxies(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Base URL for MCMP requests.
	 */
	@ModelNodeBinding(detypedName = "proxy-url")
	public String proxyUrl() {
		return this.proxyUrl;
	}

	/**
	 * Base URL for MCMP requests.
	 */
	@SuppressWarnings("unchecked")
	public T proxyUrl(java.lang.String value) {
		Object oldValue = this.proxyUrl;
		this.proxyUrl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("proxyUrl", oldValue, value);
		return (T) this;
	}

	/**
	 * Session draining strategy used during undeployment of a web application
	 */
	@ModelNodeBinding(detypedName = "session-draining-strategy")
	public SessionDrainingStrategy sessionDrainingStrategy() {
		return this.sessionDrainingStrategy;
	}

	/**
	 * Session draining strategy used during undeployment of a web application
	 */
	@SuppressWarnings("unchecked")
	public T sessionDrainingStrategy(SessionDrainingStrategy value) {
		Object oldValue = this.sessionDrainingStrategy;
		this.sessionDrainingStrategy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sessionDrainingStrategy", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Simple load provider
	 */
	@ModelNodeBinding(detypedName = "simple-load-provider")
	public Integer simpleLoadProvider() {
		return this.simpleLoadProvider;
	}

	/**
	 * Simple load provider
	 */
	@SuppressWarnings("unchecked")
	public T simpleLoadProvider(java.lang.Integer value) {
		Object oldValue = this.simpleLoadProvider;
		this.simpleLoadProvider = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("simpleLoadProvider", oldValue, value);
		return (T) this;
	}

	/**
	 * Soft maximum idle connection count in httpd
	 */
	@ModelNodeBinding(detypedName = "smax")
	public Integer smax() {
		return this.smax;
	}

	/**
	 * Soft maximum idle connection count in httpd
	 */
	@SuppressWarnings("unchecked")
	public T smax(java.lang.Integer value) {
		Object oldValue = this.smax;
		this.smax = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("smax", oldValue, value);
		return (T) this;
	}

	/**
	 * Timeout to wait for httpd to answer a MCMP message.
	 */
	@ModelNodeBinding(detypedName = "socket-timeout")
	public Integer socketTimeout() {
		return this.socketTimeout;
	}

	/**
	 * Timeout to wait for httpd to answer a MCMP message.
	 */
	@SuppressWarnings("unchecked")
	public T socketTimeout(java.lang.Integer value) {
		Object oldValue = this.socketTimeout;
		this.socketTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Number of seconds a STATUS message is sent from the application server to
	 * the reverse proxy.
	 */
	@ModelNodeBinding(detypedName = "status-interval")
	public Integer statusInterval() {
		return this.statusInterval;
	}

	/**
	 * Number of seconds a STATUS message is sent from the application server to
	 * the reverse proxy.
	 */
	@SuppressWarnings("unchecked")
	public T statusInterval(java.lang.Integer value) {
		Object oldValue = this.statusInterval;
		this.statusInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statusInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * Use sticky sessions for requests.
	 */
	@ModelNodeBinding(detypedName = "sticky-session")
	public Boolean stickySession() {
		return this.stickySession;
	}

	/**
	 * Use sticky sessions for requests.
	 */
	@SuppressWarnings("unchecked")
	public T stickySession(java.lang.Boolean value) {
		Object oldValue = this.stickySession;
		this.stickySession = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stickySession", oldValue, value);
		return (T) this;
	}

	/**
	 * Don't failover a request with session information.
	 */
	@ModelNodeBinding(detypedName = "sticky-session-force")
	public Boolean stickySessionForce() {
		return this.stickySessionForce;
	}

	/**
	 * Don't failover a request with session information.
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionForce(java.lang.Boolean value) {
		Object oldValue = this.stickySessionForce;
		this.stickySessionForce = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stickySessionForce", oldValue, value);
		return (T) this;
	}

	/**
	 * Remove session information on failover.
	 */
	@ModelNodeBinding(detypedName = "sticky-session-remove")
	public Boolean stickySessionRemove() {
		return this.stickySessionRemove;
	}

	/**
	 * Remove session information on failover.
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionRemove(java.lang.Boolean value) {
		Object oldValue = this.stickySessionRemove;
		this.stickySessionRemove = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stickySessionRemove", oldValue, value);
		return (T) this;
	}

	/**
	 * Max time to wait for context to process pending requests.
	 */
	@ModelNodeBinding(detypedName = "stop-context-timeout")
	public Integer stopContextTimeout() {
		return this.stopContextTimeout;
	}

	/**
	 * Max time to wait for context to process pending requests.
	 */
	@SuppressWarnings("unchecked")
	public T stopContextTimeout(java.lang.Integer value) {
		Object oldValue = this.stopContextTimeout;
		this.stopContextTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stopContextTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Time to live (in seconds) for idle connections above smax
	 */
	@ModelNodeBinding(detypedName = "ttl")
	public Integer ttl() {
		return this.ttl;
	}

	/**
	 * Time to live (in seconds) for idle connections above smax
	 */
	@SuppressWarnings("unchecked")
	public T ttl(java.lang.Integer value) {
		Object oldValue = this.ttl;
		this.ttl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ttl", oldValue, value);
		return (T) this;
	}

	/**
	 * Timeout to wait in httpd for an available worker to process the requests.
	 */
	@ModelNodeBinding(detypedName = "worker-timeout")
	public Integer workerTimeout() {
		return this.workerTimeout;
	}

	/**
	 * Timeout to wait in httpd for an available worker to process the requests.
	 */
	@SuppressWarnings("unchecked")
	public T workerTimeout(java.lang.Integer value) {
		Object oldValue = this.workerTimeout;
		this.workerTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("workerTimeout", oldValue, value);
		return (T) this;
	}
}