package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.audit.ProviderModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.audit.ProviderModuleSupplier;
import org.wildfly.swarm.config.security.security_domain.audit.ProviderModule;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Auditing configuration. Configures a list of provider modules to be used.
 */
@Address("/subsystem=security/security-domain=*/audit=classic")
@ResourceType("audit")
@Implicit
public class ClassicAudit<T extends ClassicAudit<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ClassicAuditResources subresources = new ClassicAuditResources();

	public ClassicAudit() {
		super();
		this.key = "classic";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ClassicAuditResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ProviderModule objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ProviderModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T providerModules(java.util.List<ProviderModule> value) {
		this.subresources.providerModules = value;
		return (T) this;
	}

	/**
	 * Add the ProviderModule object to the list of subresources
	 * 
	 * @param value
	 *            The ProviderModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerModule(ProviderModule value) {
		this.subresources.providerModules.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ProviderModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ProviderModule resource
	 * @param config
	 *            The ProviderModuleConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerModule(java.lang.String childKey,
			ProviderModuleConsumer consumer) {
		ProviderModule<? extends ProviderModule> child = new ProviderModule<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		providerModule(child);
		return (T) this;
	}

	/**
	 * Create and configure a ProviderModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ProviderModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerModule(java.lang.String childKey) {
		providerModule(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ProviderModule object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T providerModule(ProviderModuleSupplier supplier) {
		providerModule(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ClassicAudit
	 */
	public static class ClassicAuditResources {
		/**
		 * List of modules that map principal, role, and credential information
		 */
		@SubresourceInfo("providerModule")
		private List<ProviderModule> providerModules = new java.util.ArrayList<>();

		/**
		 * Get the list of ProviderModule resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ProviderModule> providerModules() {
			return this.providerModules;
		}

		public ProviderModule providerModule(java.lang.String key) {
			return this.providerModules.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}