package org.wildfly.swarm.config.security.security_domain.identity_trust;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.security.Flag;
import java.util.Map;

/**
 * List of authentication modules
 */
@Address("/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*")
@ResourceType("trust-module")
public class TrustModule<T extends TrustModule<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private String code;
	private Flag flag;
	private String module;
	private Map moduleOptions;

	public TrustModule(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public T code(java.lang.String value) {
		Object oldValue = this.code;
		this.code = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("code", oldValue, value);
		return (T) this;
	}

	/**
	 * The flag controls how the module participates in the overall procedure.
	 * Allowed values are requisite, required, sufficient or optional.
	 */
	@ModelNodeBinding(detypedName = "flag")
	public Flag flag() {
		return this.flag;
	}

	/**
	 * The flag controls how the module participates in the overall procedure.
	 * Allowed values are requisite, required, sufficient or optional.
	 */
	@SuppressWarnings("unchecked")
	public T flag(Flag value) {
		Object oldValue = this.flag;
		this.flag = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("flag", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOptions(java.util.Map value) {
		Object oldValue = this.moduleOptions;
		this.moduleOptions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("moduleOptions", oldValue, value);
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOption(java.lang.String key, java.lang.Object value) {
		if (this.moduleOptions == null) {
			this.moduleOptions = new java.util.HashMap<>();
		}
		this.moduleOptions.put(key, value);
		return (T) this;
	}
}