package org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.ContextConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.ContextSupplier;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Runtime representation of a mod_cluster node
 */
@Address("/subsystem=undertow/configuration=filter/mod-cluster=*/balancer=*/node=*")
@ResourceType("node")
public class Node<T extends Node<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private NodeResources subresources = new NodeResources();
	private List<String> aliases;
	private Integer cacheConnections;
	private Integer elected;
	private Boolean flushPackets;
	private Integer load;
	private String loadBalancingGroup;
	private Integer maxConnections;
	private Integer openConnections;
	private Integer ping;
	private Boolean queueNewRequests;
	private Long read;
	private Integer requestQueueSize;
	private String status;
	private Integer timeout;
	private Long ttl;
	private String uri;
	private Long written;

	public Node(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public NodeResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Context objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Context objects.
	 */
	@SuppressWarnings("unchecked")
	public T contexts(java.util.List<Context> value) {
		this.subresources.contexts = value;
		return (T) this;
	}

	/**
	 * Add the Context object to the list of subresources
	 * 
	 * @param value
	 *            The Context to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T context(Context value) {
		this.subresources.contexts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Context object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Context resource
	 * @param config
	 *            The ContextConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T context(java.lang.String childKey, ContextConsumer consumer) {
		Context<? extends Context> child = new Context<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		context(child);
		return (T) this;
	}

	/**
	 * Create and configure a Context object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Context resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T context(java.lang.String childKey) {
		context(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Context object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T context(ContextSupplier supplier) {
		context(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Node
	 */
	public static class NodeResources {
		/**
		 * Runtime representation of a mod_cluster context
		 */
		@SubresourceInfo("context")
		private List<Context> contexts = new java.util.ArrayList<>();

		/**
		 * Get the list of Context resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Context> contexts() {
			return this.contexts;
		}

		public Context context(java.lang.String key) {
			return this.contexts.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}

	/**
	 * The nodes aliases
	 */
	@ModelNodeBinding(detypedName = "aliases")
	public List<String> aliases() {
		return this.aliases;
	}

	/**
	 * The nodes aliases
	 */
	@SuppressWarnings("unchecked")
	public T aliases(java.util.List<String> value) {
		Object oldValue = this.aliases;
		this.aliases = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("aliases", oldValue, value);
		return (T) this;
	}

	/**
	 * The nodes aliases
	 */
	@SuppressWarnings("unchecked")
	public T alias(String value) {
		if (this.aliases == null) {
			this.aliases = new java.util.ArrayList<>();
		}
		this.aliases.add(value);
		return (T) this;
	}

	/**
	 * The nodes aliases
	 */
	@SuppressWarnings("unchecked")
	public T aliases(String... args) {
		aliases(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The number of connections to keep alive indefinitely
	 */
	@ModelNodeBinding(detypedName = "cache-connections")
	public Integer cacheConnections() {
		return this.cacheConnections;
	}

	/**
	 * The number of connections to keep alive indefinitely
	 */
	@SuppressWarnings("unchecked")
	public T cacheConnections(java.lang.Integer value) {
		Object oldValue = this.cacheConnections;
		this.cacheConnections = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheConnections", oldValue, value);
		return (T) this;
	}

	/**
	 * The elected count
	 */
	@ModelNodeBinding(detypedName = "elected")
	public Integer elected() {
		return this.elected;
	}

	/**
	 * The elected count
	 */
	@SuppressWarnings("unchecked")
	public T elected(java.lang.Integer value) {
		Object oldValue = this.elected;
		this.elected = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("elected", oldValue, value);
		return (T) this;
	}

	/**
	 * If received data should be immediately flushed
	 */
	@ModelNodeBinding(detypedName = "flush-packets")
	public Boolean flushPackets() {
		return this.flushPackets;
	}

	/**
	 * If received data should be immediately flushed
	 */
	@SuppressWarnings("unchecked")
	public T flushPackets(java.lang.Boolean value) {
		Object oldValue = this.flushPackets;
		this.flushPackets = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("flushPackets", oldValue, value);
		return (T) this;
	}

	/**
	 * The current load of this node
	 */
	@ModelNodeBinding(detypedName = "load")
	public Integer load() {
		return this.load;
	}

	/**
	 * The current load of this node
	 */
	@SuppressWarnings("unchecked")
	public T load(java.lang.Integer value) {
		Object oldValue = this.load;
		this.load = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("load", oldValue, value);
		return (T) this;
	}

	/**
	 * The load balancing group this node belongs to
	 */
	@ModelNodeBinding(detypedName = "load-balancing-group")
	public String loadBalancingGroup() {
		return this.loadBalancingGroup;
	}

	/**
	 * The load balancing group this node belongs to
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroup(java.lang.String value) {
		Object oldValue = this.loadBalancingGroup;
		this.loadBalancingGroup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("loadBalancingGroup", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of connections per IO thread
	 */
	@ModelNodeBinding(detypedName = "max-connections")
	public Integer maxConnections() {
		return this.maxConnections;
	}

	/**
	 * The maximum number of connections per IO thread
	 */
	@SuppressWarnings("unchecked")
	public T maxConnections(java.lang.Integer value) {
		Object oldValue = this.maxConnections;
		this.maxConnections = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxConnections", oldValue, value);
		return (T) this;
	}

	/**
	 * The current number of open connections
	 */
	@ModelNodeBinding(detypedName = "open-connections")
	public Integer openConnections() {
		return this.openConnections;
	}

	/**
	 * The current number of open connections
	 */
	@SuppressWarnings("unchecked")
	public T openConnections(java.lang.Integer value) {
		Object oldValue = this.openConnections;
		this.openConnections = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("openConnections", oldValue, value);
		return (T) this;
	}

	/**
	 * The nodes ping
	 */
	@ModelNodeBinding(detypedName = "ping")
	public Integer ping() {
		return this.ping;
	}

	/**
	 * The nodes ping
	 */
	@SuppressWarnings("unchecked")
	public T ping(java.lang.Integer value) {
		Object oldValue = this.ping;
		this.ping = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ping", oldValue, value);
		return (T) this;
	}

	/**
	 * If a request is received and there is no worker immediately available
	 * should it be queued
	 */
	@ModelNodeBinding(detypedName = "queue-new-requests")
	public Boolean queueNewRequests() {
		return this.queueNewRequests;
	}

	/**
	 * If a request is received and there is no worker immediately available
	 * should it be queued
	 */
	@SuppressWarnings("unchecked")
	public T queueNewRequests(java.lang.Boolean value) {
		Object oldValue = this.queueNewRequests;
		this.queueNewRequests = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueNewRequests", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of bytes read from the node
	 */
	@ModelNodeBinding(detypedName = "read")
	public Long read() {
		return this.read;
	}

	/**
	 * The number of bytes read from the node
	 */
	@SuppressWarnings("unchecked")
	public T read(java.lang.Long value) {
		Object oldValue = this.read;
		this.read = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("read", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of the request queue
	 */
	@ModelNodeBinding(detypedName = "request-queue-size")
	public Integer requestQueueSize() {
		return this.requestQueueSize;
	}

	/**
	 * The size of the request queue
	 */
	@SuppressWarnings("unchecked")
	public T requestQueueSize(java.lang.Integer value) {
		Object oldValue = this.requestQueueSize;
		this.requestQueueSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("requestQueueSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The current status of this node
	 */
	@ModelNodeBinding(detypedName = "status")
	public String status() {
		return this.status;
	}

	/**
	 * The current status of this node
	 */
	@SuppressWarnings("unchecked")
	public T status(java.lang.String value) {
		Object oldValue = this.status;
		this.status = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("status", oldValue, value);
		return (T) this;
	}

	/**
	 * The request timeout
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Integer timeout() {
		return this.timeout;
	}

	/**
	 * The request timeout
	 */
	@SuppressWarnings("unchecked")
	public T timeout(java.lang.Integer value) {
		Object oldValue = this.timeout;
		this.timeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The time connections will stay alive with no requests before being
	 * closed, if the number of connections is larger than cache-connections
	 */
	@ModelNodeBinding(detypedName = "ttl")
	public Long ttl() {
		return this.ttl;
	}

	/**
	 * The time connections will stay alive with no requests before being
	 * closed, if the number of connections is larger than cache-connections
	 */
	@SuppressWarnings("unchecked")
	public T ttl(java.lang.Long value) {
		Object oldValue = this.ttl;
		this.ttl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ttl", oldValue, value);
		return (T) this;
	}

	/**
	 * The URI that the load balancer uses to connect to the node
	 */
	@ModelNodeBinding(detypedName = "uri")
	public String uri() {
		return this.uri;
	}

	/**
	 * The URI that the load balancer uses to connect to the node
	 */
	@SuppressWarnings("unchecked")
	public T uri(java.lang.String value) {
		Object oldValue = this.uri;
		this.uri = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("uri", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of bytes transferred to the node
	 */
	@ModelNodeBinding(detypedName = "written")
	public Long written() {
		return this.written;
	}

	/**
	 * The number of bytes transferred to the node
	 */
	@SuppressWarnings("unchecked")
	public T written(java.lang.Long value) {
		Object oldValue = this.written;
		this.written = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("written", oldValue, value);
		return (T) this;
	}
}