package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configures special session handing for crawler bots
 */
@Address("/subsystem=undertow/servlet-container=*/setting=crawler-session-management")
@ResourceType("setting")
@Implicit
public class CrawlerSessionManagementSetting<T extends CrawlerSessionManagementSetting<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer sessionTimeout;
	private String userAgents;

	public CrawlerSessionManagementSetting() {
		super();
		this.key = "crawler-session-management";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The session timeout for sessions that are owned by crawlers
	 */
	@ModelNodeBinding(detypedName = "session-timeout")
	public Integer sessionTimeout() {
		return this.sessionTimeout;
	}

	/**
	 * The session timeout for sessions that are owned by crawlers
	 */
	@SuppressWarnings("unchecked")
	public T sessionTimeout(java.lang.Integer value) {
		Object oldValue = this.sessionTimeout;
		this.sessionTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sessionTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Regular expression that is used to match the user agenet of a crawler
	 */
	@ModelNodeBinding(detypedName = "user-agents")
	public String userAgents() {
		return this.userAgents;
	}

	/**
	 * Regular expression that is used to match the user agenet of a crawler
	 */
	@SuppressWarnings("unchecked")
	public T userAgents(java.lang.String value) {
		Object oldValue = this.userAgents;
		this.userAgents = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("userAgents", oldValue, value);
		return (T) this;
	}
}