/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access.constraint.application_classification.type;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesTo;
import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesToConsumer;
import org.wildfly.swarm.config.management.access.constraint.type.classification.AppliesToSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/core-service=management/access=authorization/constraint=application-classification/type=*/classification=*")
@ResourceType(value="classification")
public class Classification<T extends Classification<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ClassificationResources subresources = new ClassificationResources();
    private Boolean configuredApplication;
    private Boolean defaultApplication;

    public Classification(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ClassificationResources subresources() {
        return this.subresources;
    }

    public T appliesTos(List<AppliesTo> value) {
        this.subresources.appliesTos = value;
        return (T)this;
    }

    public T appliesTo(AppliesTo value) {
        this.subresources.appliesTos.add(value);
        return (T)this;
    }

    public T appliesTo(String childKey, AppliesToConsumer consumer) {
        AppliesTo child = new AppliesTo(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.appliesTo(child);
        return (T)this;
    }

    public T appliesTo(String childKey) {
        this.appliesTo(childKey, null);
        return (T)this;
    }

    public T appliesTo(AppliesToSupplier supplier) {
        this.appliesTo(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="configured-application")
    public Boolean configuredApplication() {
        return this.configuredApplication;
    }

    public T configuredApplication(Boolean value) {
        Boolean oldValue = this.configuredApplication;
        this.configuredApplication = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("configuredApplication", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-application")
    public Boolean defaultApplication() {
        return this.defaultApplication;
    }

    public T defaultApplication(Boolean value) {
        Boolean oldValue = this.defaultApplication;
        this.defaultApplication = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultApplication", oldValue, value);
        }
        return (T)this;
    }

    public static class ClassificationResources {
        @SubresourceInfo(value="appliesTo")
        private List<AppliesTo> appliesTos = new ArrayList<AppliesTo>();

        @Subresource
        public List<AppliesTo> appliesTos() {
            return this.appliesTos;
        }

        public AppliesTo appliesTo(String key) {
            return this.appliesTos.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

