/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.remoting;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.remoting.Property;
import org.wildfly.swarm.config.remoting.PropertyConsumer;
import org.wildfly.swarm.config.remoting.PropertySupplier;
import org.wildfly.swarm.config.remoting.SASLSecurity;
import org.wildfly.swarm.config.remoting.SASLSecurityConsumer;
import org.wildfly.swarm.config.remoting.SASLSecuritySupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=remoting/connector=*")
@ResourceType(value="connector")
public class Connector<T extends Connector<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ConnectorResources subresources = new ConnectorResources();
    private String authenticationProvider;
    private String saslProtocol;
    private String securityRealm;
    private String serverName;
    private String socketBinding;

    public Connector(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ConnectorResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    public T saslSecurity(SASLSecurity value) {
        this.subresources.saslSecurity = value;
        return (T)this;
    }

    public T saslSecurity(SASLSecurityConsumer consumer) {
        SASLSecurity child = new SASLSecurity();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.saslSecurity = child;
        return (T)this;
    }

    public T saslSecurity() {
        SASLSecurity child = new SASLSecurity();
        this.subresources.saslSecurity = child;
        return (T)this;
    }

    public T saslSecurity(SASLSecuritySupplier supplier) {
        this.subresources.saslSecurity = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-provider")
    public String authenticationProvider() {
        return this.authenticationProvider;
    }

    public T authenticationProvider(String value) {
        String oldValue = this.authenticationProvider;
        this.authenticationProvider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationProvider", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-protocol")
    public String saslProtocol() {
        return this.saslProtocol;
    }

    public T saslProtocol(String value) {
        String oldValue = this.saslProtocol;
        this.saslProtocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("saslProtocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public T securityRealm(String value) {
        String oldValue = this.securityRealm;
        this.securityRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-name")
    public String serverName() {
        return this.serverName;
    }

    public T serverName(String value) {
        String oldValue = this.serverName;
        this.serverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }

    public static class ConnectorResources {
        @SubresourceInfo(value="property")
        private List<Property> properties = new ArrayList<Property>();
        private SASLSecurity saslSecurity;

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public SASLSecurity saslSecurity() {
            return this.saslSecurity;
        }
    }
}

