/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule;
import org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModuleSupplier;

@Address(value="/subsystem=security/security-domain=*/identity-trust=classic")
@ResourceType(value="identity-trust")
@Implicit
public class ClassicIdentityTrust<T extends ClassicIdentityTrust<T>>
extends HashMap
implements Keyed {
    private String key = "classic";
    private PropertyChangeSupport pcs;
    private ClassicIdentityTrustResources subresources = new ClassicIdentityTrustResources();

    public ClassicIdentityTrust() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ClassicIdentityTrustResources subresources() {
        return this.subresources;
    }

    public T trustModules(List<TrustModule> value) {
        this.subresources.trustModules = value;
        return (T)this;
    }

    public T trustModule(TrustModule value) {
        this.subresources.trustModules.add(value);
        return (T)this;
    }

    public T trustModule(String childKey, TrustModuleConsumer consumer) {
        TrustModule child = new TrustModule(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.trustModule(child);
        return (T)this;
    }

    public T trustModule(String childKey) {
        this.trustModule(childKey, null);
        return (T)this;
    }

    public T trustModule(TrustModuleSupplier supplier) {
        this.trustModule(supplier.get());
        return (T)this;
    }

    public static class ClassicIdentityTrustResources {
        @SubresourceInfo(value="trustModule")
        private List<TrustModule> trustModules = new ArrayList<TrustModule>();

        @Subresource
        public List<TrustModule> trustModules() {
            return this.trustModules;
        }

        public TrustModule trustModule(String key) {
            return this.trustModules.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

