package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.singleton.SingletonPolicyConsumer;
import org.wildfly.swarm.config.singleton.SingletonPolicySupplier;
import org.wildfly.swarm.config.singleton.SingletonPolicy;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the singleton subsystem
 */
@Address("/subsystem=singleton")
@ResourceType("subsystem")
@Implicit
public class Singleton<T extends Singleton<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private SingletonResources subresources = new SingletonResources();
	@AttributeDocumentation("The default singleton policy")
	private String attributeDefault;

	public Singleton() {
		super();
		this.key = "singleton";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public SingletonResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all SingletonPolicy objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SingletonPolicy objects.
	 */
	@SuppressWarnings("unchecked")
	public T singletonPolicies(java.util.List<SingletonPolicy> value) {
		this.subresources.singletonPolicies = value;
		return (T) this;
	}

	/**
	 * Add the SingletonPolicy object to the list of subresources
	 * 
	 * @param value
	 *            The SingletonPolicy to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T singletonPolicy(SingletonPolicy value) {
		this.subresources.singletonPolicies.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SingletonPolicy object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SingletonPolicy resource
	 * @param config
	 *            The SingletonPolicyConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T singletonPolicy(java.lang.String childKey,
			SingletonPolicyConsumer consumer) {
		SingletonPolicy<? extends SingletonPolicy> child = new SingletonPolicy<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		singletonPolicy(child);
		return (T) this;
	}

	/**
	 * Create and configure a SingletonPolicy object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SingletonPolicy resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T singletonPolicy(java.lang.String childKey) {
		singletonPolicy(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SingletonPolicy object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T singletonPolicy(SingletonPolicySupplier supplier) {
		singletonPolicy(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Singleton
	 */
	public static class SingletonResources {
		/**
		 * A singleton policy
		 */
		@ResourceDocumentation("A singleton policy")
		@SubresourceInfo("singletonPolicy")
		private List<SingletonPolicy> singletonPolicies = new java.util.ArrayList<>();

		/**
		 * Get the list of SingletonPolicy resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SingletonPolicy> singletonPolicies() {
			return this.singletonPolicies;
		}

		public SingletonPolicy singletonPolicy(java.lang.String key) {
			return this.singletonPolicies.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The default singleton policy
	 */
	@ModelNodeBinding(detypedName = "default")
	public String attributeDefault() {
		return this.attributeDefault;
	}

	/**
	 * The default singleton policy
	 */
	@SuppressWarnings("unchecked")
	public T attributeDefault(java.lang.String value) {
		Object oldValue = this.attributeDefault;
		this.attributeDefault = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeDefault", oldValue, value);
		return (T) this;
	}
}