package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.JGroupsTransport;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JGroupsTransportConsumer<T extends JGroupsTransport<T>> {

	/**
	 * Configure a pre-constructed instance of JGroupsTransport resource
	 * 
	 * @parameter Instance of JGroupsTransport to configure
	 * @return nothing
	 */
	void accept(T value);

	default JGroupsTransportConsumer<T> andThen(
			JGroupsTransportConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}