package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Security Vault for attributes.
 */
@Address("/subsystem=security/vault=classic")
@ResourceType("vault")
@Implicit
public class ClassicVault<T extends ClassicVault<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Fully Qualified Name of the Security Vault Implementation.")
	private String code;
	@AttributeDocumentation("Security Vault options.")
	private Map vaultOptions;

	public ClassicVault() {
		super();
		this.key = "classic";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Fully Qualified Name of the Security Vault Implementation.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Fully Qualified Name of the Security Vault Implementation.
	 */
	@SuppressWarnings("unchecked")
	public T code(java.lang.String value) {
		Object oldValue = this.code;
		this.code = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("code", oldValue, value);
		return (T) this;
	}

	/**
	 * Security Vault options.
	 */
	@ModelNodeBinding(detypedName = "vault-options")
	public Map vaultOptions() {
		return this.vaultOptions;
	}

	/**
	 * Security Vault options.
	 */
	@SuppressWarnings("unchecked")
	public T vaultOptions(java.util.Map value) {
		Object oldValue = this.vaultOptions;
		this.vaultOptions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("vaultOptions", oldValue, value);
		return (T) this;
	}

	/**
	 * Security Vault options.
	 */
	@SuppressWarnings("unchecked")
	public T vaultOption(java.lang.String key, java.lang.Object value) {
		if (this.vaultOptions == null) {
			this.vaultOptions = new java.util.HashMap<>();
		}
		this.vaultOptions.put(key, value);
		return (T) this;
	}
}