/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access.syslog_handler;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/core-service=management/access=audit/syslog-handler=*/protocol=tcp")
@ResourceType(value="protocol")
@Implicit
public class TcpProtocol<T extends TcpProtocol<T>>
extends HashMap
implements Keyed {
    private String key = "tcp";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The host of the syslog server for the tcp requests.")
    private String host;
    @AttributeDocumentation(value="The message transfer setting as described in section 3.4 of RFC-6587. This can either be OCTET_COUNTING as described in section 3.4.1 of RFC-6587, or NON_TRANSPARENT_FRAMING as described in section 3.4.1 of RFC-6587. See your syslog provider's documentation for what is supported.")
    private String messageTransfer;
    @AttributeDocumentation(value="The port of the syslog server for the tcp requests.")
    private Integer port;
    @AttributeDocumentation(value="If a connection drop is detected, the number of seconds to wait before reconnecting. A negative number means don't reconnect automatically.")
    private Integer reconnectTimeout;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="host")
    public String host() {
        return this.host;
    }

    public T host(String value) {
        String oldValue = this.host;
        this.host = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("host", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-transfer")
    public String messageTransfer() {
        return this.messageTransfer;
    }

    public T messageTransfer(String value) {
        String oldValue = this.messageTransfer;
        this.messageTransfer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageTransfer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="port")
    public Integer port() {
        return this.port;
    }

    public T port(Integer value) {
        Integer oldValue = this.port;
        this.port = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("port", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reconnect-timeout")
    public Integer reconnectTimeout() {
        return this.reconnectTimeout;
    }

    public T reconnectTimeout(Integer value) {
        Integer oldValue = this.reconnectTimeout;
        this.reconnectTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reconnectTimeout", oldValue, value);
        }
        return (T)this;
    }
}

