/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access.syslog_handler.protocol;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/core-service=management/access=audit/syslog-handler=*/protocol=tls/authentication=truststore")
@ResourceType(value="authentication")
@Implicit
public class TruststoreAuthentication<T extends TruststoreAuthentication<T>>
extends HashMap
implements Keyed {
    private String key = "truststore";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The password for the truststore.")
    private String keystorePassword;
    @AttributeDocumentation(value="=The path of the truststore.")
    private String keystorePath;
    @AttributeDocumentation(value="The name of another previously named path, or of one of the standard paths provided by the system. If 'keystore-relative-to' is provided, the value of the 'keystore-path' attribute is treated as relative to the path specified by this attribute.")
    private String keystoreRelativeTo;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="keystore-password")
    public String keystorePassword() {
        return this.keystorePassword;
    }

    public T keystorePassword(String value) {
        String oldValue = this.keystorePassword;
        this.keystorePassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystorePassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-path")
    public String keystorePath() {
        return this.keystorePath;
    }

    public T keystorePath(String value) {
        String oldValue = this.keystorePath;
        this.keystorePath = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystorePath", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-relative-to")
    public String keystoreRelativeTo() {
        return this.keystoreRelativeTo;
    }

    public T keystoreRelativeTo(String value) {
        String oldValue = this.keystoreRelativeTo;
        this.keystoreRelativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystoreRelativeTo", oldValue, value);
        }
        return (T)this;
    }
}

