/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.transactions.log_store.transactions;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=transactions/log-store=log-store/transactions=*/participants=*")
@ResourceType(value="participants")
public class Participants<T extends Participants<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The JCA enterprise information system's product name.")
    private String eisProductName;
    @AttributeDocumentation(value="The JCA enterprise information system's product version")
    private String eisProductVersion;
    @AttributeDocumentation(value="The JMX name of this participant.")
    private String jmxName;
    @AttributeDocumentation(value="JNDI name of this participant.")
    private String jndiName;
    @AttributeDocumentation(value="Reports the commitment status of this participant (can be one of Pending, Prepared, Failed, Heuristic or Readonly).")
    private Status status;
    @AttributeDocumentation(value="The type name under which this record is stored.")
    private String type;

    public Participants(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="eis-product-name")
    public String eisProductName() {
        return this.eisProductName;
    }

    public T eisProductName(String value) {
        String oldValue = this.eisProductName;
        this.eisProductName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("eisProductName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="eis-product-version")
    public String eisProductVersion() {
        return this.eisProductVersion;
    }

    public T eisProductVersion(String value) {
        String oldValue = this.eisProductVersion;
        this.eisProductVersion = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("eisProductVersion", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jmx-name")
    public String jmxName() {
        return this.jmxName;
    }

    public T jmxName(String value) {
        String oldValue = this.jmxName;
        this.jmxName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jmxName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="status")
    public Status status() {
        return this.status;
    }

    public T status(Status value) {
        Status oldValue = this.status;
        this.status = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("status", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public String type() {
        return this.type;
    }

    public T type(String value) {
        String oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", oldValue, value);
        }
        return (T)this;
    }

    public static enum Status {
        PENDING("PENDING"),
        PREPARED("PREPARED"),
        FAILED("FAILED"),
        HEURISTIC("HEURISTIC"),
        READONLY("READONLY");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Status(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

