package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.ejb3.StrictMaxBeanInstancePool;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface StrictMaxBeanInstancePoolConsumer<T extends StrictMaxBeanInstancePool<T>> {

	/**
	 * Configure a pre-constructed instance of StrictMaxBeanInstancePool
	 * resource
	 * 
	 * @parameter Instance of StrictMaxBeanInstancePool to configure
	 * @return nothing
	 */
	void accept(T value);

	default StrictMaxBeanInstancePoolConsumer<T> andThen(
			StrictMaxBeanInstancePoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}