package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.FileStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface FileStoreConsumer<T extends FileStore<T>> {

	/**
	 * Configure a pre-constructed instance of FileStore resource
	 * 
	 * @parameter Instance of FileStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default FileStoreConsumer<T> andThen(FileStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}