package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;

/**
 * The iiop-openjdk subsystem configuration.
 */
@Address("/subsystem=iiop-openjdk")
@ResourceType("subsystem")
@Implicit
public class IIOPOpenjdk<T extends IIOPOpenjdk<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("A list of generic key/value properties.")
	private Map properties;
	@AttributeDocumentation("The authentication method. Valid values are 'none' and 'username_password'.")
	private AuthMethod authMethod;
	@AttributeDocumentation("The authentication service (AS) realm name.")
	private String realm;
	@AttributeDocumentation("Indicates if authentication is required (true) or not (false).")
	private Boolean required;
	@AttributeDocumentation("Indicates whether the security interceptors are to be installed (on) or not (off).")
	private Security security;
	@AttributeDocumentation("Indicates whether the transactions interceptors are to be installed (on or spec) or not (off). The value 'on' enabled JTS while 'spec' enables a spec compliant mode (non JTS) that rejects incoming transaction contexts.")
	private Transactions transactions;
	@AttributeDocumentation("Indicates whether the root context should be exported as corbaloc::address:port/NameService (on) or not (off).")
	private Boolean exportCorbaloc;
	@AttributeDocumentation("The naming service root context.")
	private String rootContext;
	@AttributeDocumentation("The GIOP version to be used.")
	private String giopVersion;
	@AttributeDocumentation("Persistent id of the server. Persistent object references are valid across many activactions of the server and they identify it using this property. As a result of that: many activations of the same server should have this property set to the same value, different server instances running on the same host should have different server ids.")
	private String persistentServerId;
	@AttributeDocumentation("The name of the socket binding configuration that specifies the ORB port.")
	private String socketBinding;
	@AttributeDocumentation("The name of the socket binding configuration that specifies the ORB SSL port.")
	private String sslSocketBinding;
	@AttributeDocumentation("Indicates whether the caller identity should be propagated in the SAS context or not. Valid values are 'none' and 'supported'.")
	private CallerPropagation callerPropagation;
	@AttributeDocumentation("Indicates whether SSL components should be added by an IOR interceptor (on) or not (off).")
	private Boolean addComponentViaInterceptor;
	@AttributeDocumentation("Value that indicates the client SSL required parameters (None, ServerAuth, ClientAuth, MutualAuth).")
	private ClientRequires clientRequires;
	@AttributeDocumentation("Value that indicates the client SSL supported parameters (None, ServerAuth, ClientAuth, MutualAuth).")
	private ClientSupports clientSupports;
	@AttributeDocumentation("The name of the security domain that holds the key and trust stores that will be used to establish SSL connections.")
	private String securityDomain;
	@AttributeDocumentation("Value that indicates the server SSL required parameters (None, ServerAuth, ClientAuth, MutualAuth).")
	private ServerRequires serverRequires;
	@AttributeDocumentation("Value that indicates the server SSL supported parameters (None, ServerAuth, ClientAuth, MutualAuth).")
	private ServerSupports serverSupports;
	@AttributeDocumentation("Indicates whether SSL is to be supported (on) or not (off).")
	private Boolean supportSsl;
	@AttributeDocumentation("TCP connection cache parameter. Each time the number of connections exceeds this value ORB tries to reclaim connections. Number of reclaimed connections is specified by tcp-number-to-reclaim property. If this property is not set then it is configured as OpenJDK ORB default.")
	private Integer highWaterMark;
	@AttributeDocumentation("TCP connection cache parameter. Each time number of connections exceeds tcp-high-water-mark property then ORB tries to reclaim connections. Number of reclaimed connections is specified by this property. If it is not set then it is configured as OpenJDK ORB default.")
	private Integer numberToReclaim;
	@AttributeDocumentation("Indicates whether the transport must require confidentiality protection or not. Valid values are 'none', 'supported' and 'required'.")
	private Confidentiality confidentiality;
	@AttributeDocumentation("Indicates whether the transport must require misordering detection or not. Valid values are 'none', 'supported' and 'required'.")
	private DetectMisordering detectMisordering;
	@AttributeDocumentation("Indicates whether the transport must require replay detection or not. Valid values are 'none', 'supported' and 'required'.")
	private DetectReplay detectReplay;
	@AttributeDocumentation("Indicates whether the transport must require integrity protection or not. Valid values are 'none', 'supported' and 'required'.")
	private Integrity integrity;
	@AttributeDocumentation("Indicates if the transport must require trust in client to be established. Valid values are 'none', 'supported' and 'required'.")
	private TrustInClient trustInClient;
	@AttributeDocumentation("Indicates if the transport must require trust in target to be established. Valid values are 'none' and 'supported'.")
	private TrustInTarget trustInTarget;

	public IIOPOpenjdk() {
		super();
		this.key = "iiop-openjdk";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum AuthMethod {
		NONE("none"), USERNAME_PASSWORD("username_password");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		AuthMethod(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum Security {
		IDENTITY("identity"), CLIENT("client"), NONE("none");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Security(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum Transactions {
		FULL("full"), NONE("none"), SPEC("spec");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Transactions(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum CallerPropagation {
		NONE("none"), SUPPORTED("supported");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		CallerPropagation(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum ClientRequires {
		NONE("None"), SERVERAUTH("ServerAuth"), CLIENTAUTH("ClientAuth"), MUTUALAUTH(
				"MutualAuth");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		ClientRequires(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum ClientSupports {
		NONE("None"), SERVERAUTH("ServerAuth"), CLIENTAUTH("ClientAuth"), MUTUALAUTH(
				"MutualAuth");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		ClientSupports(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum ServerRequires {
		NONE("None"), SERVERAUTH("ServerAuth"), CLIENTAUTH("ClientAuth"), MUTUALAUTH(
				"MutualAuth");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		ServerRequires(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum ServerSupports {
		NONE("None"), SERVERAUTH("ServerAuth"), CLIENTAUTH("ClientAuth"), MUTUALAUTH(
				"MutualAuth");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		ServerSupports(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum Confidentiality {
		NONE("none"), SUPPORTED("supported"), REQUIRED("required");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Confidentiality(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum DetectMisordering {
		NONE("none"), SUPPORTED("supported"), REQUIRED("required");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		DetectMisordering(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum DetectReplay {
		NONE("none"), SUPPORTED("supported"), REQUIRED("required");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		DetectReplay(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum Integrity {
		NONE("none"), SUPPORTED("supported"), REQUIRED("required");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Integrity(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum TrustInClient {
		NONE("none"), SUPPORTED("supported"), REQUIRED("required");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		TrustInClient(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum TrustInTarget {
		NONE("none"), SUPPORTED("supported");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		TrustInTarget(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * A list of generic key/value properties.
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * A list of generic key/value properties.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.Map value) {
		Object oldValue = this.properties;
		this.properties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("properties", oldValue, value);
		return (T) this;
	}

	/**
	 * A list of generic key/value properties.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.properties == null) {
			this.properties = new java.util.HashMap<>();
		}
		this.properties.put(key, value);
		return (T) this;
	}

	/**
	 * The authentication method. Valid values are 'none' and
	 * 'username_password'.
	 */
	@ModelNodeBinding(detypedName = "auth-method")
	public AuthMethod authMethod() {
		return this.authMethod;
	}

	/**
	 * The authentication method. Valid values are 'none' and
	 * 'username_password'.
	 */
	@SuppressWarnings("unchecked")
	public T authMethod(AuthMethod value) {
		Object oldValue = this.authMethod;
		this.authMethod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authMethod", oldValue, value);
		return (T) this;
	}

	/**
	 * The authentication service (AS) realm name.
	 */
	@ModelNodeBinding(detypedName = "realm")
	public String realm() {
		return this.realm;
	}

	/**
	 * The authentication service (AS) realm name.
	 */
	@SuppressWarnings("unchecked")
	public T realm(java.lang.String value) {
		Object oldValue = this.realm;
		this.realm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realm", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates if authentication is required (true) or not (false).
	 */
	@ModelNodeBinding(detypedName = "required")
	public Boolean required() {
		return this.required;
	}

	/**
	 * Indicates if authentication is required (true) or not (false).
	 */
	@SuppressWarnings("unchecked")
	public T required(java.lang.Boolean value) {
		Object oldValue = this.required;
		this.required = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("required", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether the security interceptors are to be installed (on) or
	 * not (off).
	 */
	@ModelNodeBinding(detypedName = "security")
	public Security security() {
		return this.security;
	}

	/**
	 * Indicates whether the security interceptors are to be installed (on) or
	 * not (off).
	 */
	@SuppressWarnings("unchecked")
	public T security(Security value) {
		Object oldValue = this.security;
		this.security = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("security", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether the transactions interceptors are to be installed (on
	 * or spec) or not (off). The value 'on' enabled JTS while 'spec' enables a
	 * spec compliant mode (non JTS) that rejects incoming transaction contexts.
	 */
	@ModelNodeBinding(detypedName = "transactions")
	public Transactions transactions() {
		return this.transactions;
	}

	/**
	 * Indicates whether the transactions interceptors are to be installed (on
	 * or spec) or not (off). The value 'on' enabled JTS while 'spec' enables a
	 * spec compliant mode (non JTS) that rejects incoming transaction contexts.
	 */
	@SuppressWarnings("unchecked")
	public T transactions(Transactions value) {
		Object oldValue = this.transactions;
		this.transactions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transactions", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether the root context should be exported as
	 * corbaloc::address:port/NameService (on) or not (off).
	 */
	@ModelNodeBinding(detypedName = "export-corbaloc")
	public Boolean exportCorbaloc() {
		return this.exportCorbaloc;
	}

	/**
	 * Indicates whether the root context should be exported as
	 * corbaloc::address:port/NameService (on) or not (off).
	 */
	@SuppressWarnings("unchecked")
	public T exportCorbaloc(java.lang.Boolean value) {
		Object oldValue = this.exportCorbaloc;
		this.exportCorbaloc = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("exportCorbaloc", oldValue, value);
		return (T) this;
	}

	/**
	 * The naming service root context.
	 */
	@ModelNodeBinding(detypedName = "root-context")
	public String rootContext() {
		return this.rootContext;
	}

	/**
	 * The naming service root context.
	 */
	@SuppressWarnings("unchecked")
	public T rootContext(java.lang.String value) {
		Object oldValue = this.rootContext;
		this.rootContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rootContext", oldValue, value);
		return (T) this;
	}

	/**
	 * The GIOP version to be used.
	 */
	@ModelNodeBinding(detypedName = "giop-version")
	public String giopVersion() {
		return this.giopVersion;
	}

	/**
	 * The GIOP version to be used.
	 */
	@SuppressWarnings("unchecked")
	public T giopVersion(java.lang.String value) {
		Object oldValue = this.giopVersion;
		this.giopVersion = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("giopVersion", oldValue, value);
		return (T) this;
	}

	/**
	 * Persistent id of the server. Persistent object references are valid
	 * across many activactions of the server and they identify it using this
	 * property. As a result of that: many activations of the same server should
	 * have this property set to the same value, different server instances
	 * running on the same host should have different server ids.
	 */
	@ModelNodeBinding(detypedName = "persistent-server-id")
	public String persistentServerId() {
		return this.persistentServerId;
	}

	/**
	 * Persistent id of the server. Persistent object references are valid
	 * across many activactions of the server and they identify it using this
	 * property. As a result of that: many activations of the same server should
	 * have this property set to the same value, different server instances
	 * running on the same host should have different server ids.
	 */
	@SuppressWarnings("unchecked")
	public T persistentServerId(java.lang.String value) {
		Object oldValue = this.persistentServerId;
		this.persistentServerId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("persistentServerId", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the socket binding configuration that specifies the ORB port.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The name of the socket binding configuration that specifies the ORB port.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the socket binding configuration that specifies the ORB SSL
	 * port.
	 */
	@ModelNodeBinding(detypedName = "ssl-socket-binding")
	public String sslSocketBinding() {
		return this.sslSocketBinding;
	}

	/**
	 * The name of the socket binding configuration that specifies the ORB SSL
	 * port.
	 */
	@SuppressWarnings("unchecked")
	public T sslSocketBinding(java.lang.String value) {
		Object oldValue = this.sslSocketBinding;
		this.sslSocketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sslSocketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether the caller identity should be propagated in the SAS
	 * context or not. Valid values are 'none' and 'supported'.
	 */
	@ModelNodeBinding(detypedName = "caller-propagation")
	public CallerPropagation callerPropagation() {
		return this.callerPropagation;
	}

	/**
	 * Indicates whether the caller identity should be propagated in the SAS
	 * context or not. Valid values are 'none' and 'supported'.
	 */
	@SuppressWarnings("unchecked")
	public T callerPropagation(CallerPropagation value) {
		Object oldValue = this.callerPropagation;
		this.callerPropagation = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("callerPropagation", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether SSL components should be added by an IOR interceptor
	 * (on) or not (off).
	 */
	@ModelNodeBinding(detypedName = "add-component-via-interceptor")
	public Boolean addComponentViaInterceptor() {
		return this.addComponentViaInterceptor;
	}

	/**
	 * Indicates whether SSL components should be added by an IOR interceptor
	 * (on) or not (off).
	 */
	@SuppressWarnings("unchecked")
	public T addComponentViaInterceptor(java.lang.Boolean value) {
		Object oldValue = this.addComponentViaInterceptor;
		this.addComponentViaInterceptor = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("addComponentViaInterceptor", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Value that indicates the client SSL required parameters (None,
	 * ServerAuth, ClientAuth, MutualAuth).
	 */
	@ModelNodeBinding(detypedName = "client-requires")
	public ClientRequires clientRequires() {
		return this.clientRequires;
	}

	/**
	 * Value that indicates the client SSL required parameters (None,
	 * ServerAuth, ClientAuth, MutualAuth).
	 */
	@SuppressWarnings("unchecked")
	public T clientRequires(ClientRequires value) {
		Object oldValue = this.clientRequires;
		this.clientRequires = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientRequires", oldValue, value);
		return (T) this;
	}

	/**
	 * Value that indicates the client SSL supported parameters (None,
	 * ServerAuth, ClientAuth, MutualAuth).
	 */
	@ModelNodeBinding(detypedName = "client-supports")
	public ClientSupports clientSupports() {
		return this.clientSupports;
	}

	/**
	 * Value that indicates the client SSL supported parameters (None,
	 * ServerAuth, ClientAuth, MutualAuth).
	 */
	@SuppressWarnings("unchecked")
	public T clientSupports(ClientSupports value) {
		Object oldValue = this.clientSupports;
		this.clientSupports = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientSupports", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the security domain that holds the key and trust stores that
	 * will be used to establish SSL connections.
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * The name of the security domain that holds the key and trust stores that
	 * will be used to establish SSL connections.
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String value) {
		Object oldValue = this.securityDomain;
		this.securityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomain", oldValue, value);
		return (T) this;
	}

	/**
	 * Value that indicates the server SSL required parameters (None,
	 * ServerAuth, ClientAuth, MutualAuth).
	 */
	@ModelNodeBinding(detypedName = "server-requires")
	public ServerRequires serverRequires() {
		return this.serverRequires;
	}

	/**
	 * Value that indicates the server SSL required parameters (None,
	 * ServerAuth, ClientAuth, MutualAuth).
	 */
	@SuppressWarnings("unchecked")
	public T serverRequires(ServerRequires value) {
		Object oldValue = this.serverRequires;
		this.serverRequires = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverRequires", oldValue, value);
		return (T) this;
	}

	/**
	 * Value that indicates the server SSL supported parameters (None,
	 * ServerAuth, ClientAuth, MutualAuth).
	 */
	@ModelNodeBinding(detypedName = "server-supports")
	public ServerSupports serverSupports() {
		return this.serverSupports;
	}

	/**
	 * Value that indicates the server SSL supported parameters (None,
	 * ServerAuth, ClientAuth, MutualAuth).
	 */
	@SuppressWarnings("unchecked")
	public T serverSupports(ServerSupports value) {
		Object oldValue = this.serverSupports;
		this.serverSupports = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverSupports", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether SSL is to be supported (on) or not (off).
	 */
	@ModelNodeBinding(detypedName = "support-ssl")
	public Boolean supportSsl() {
		return this.supportSsl;
	}

	/**
	 * Indicates whether SSL is to be supported (on) or not (off).
	 */
	@SuppressWarnings("unchecked")
	public T supportSsl(java.lang.Boolean value) {
		Object oldValue = this.supportSsl;
		this.supportSsl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("supportSsl", oldValue, value);
		return (T) this;
	}

	/**
	 * TCP connection cache parameter. Each time the number of connections
	 * exceeds this value ORB tries to reclaim connections. Number of reclaimed
	 * connections is specified by tcp-number-to-reclaim property. If this
	 * property is not set then it is configured as OpenJDK ORB default.
	 */
	@ModelNodeBinding(detypedName = "high-water-mark")
	public Integer highWaterMark() {
		return this.highWaterMark;
	}

	/**
	 * TCP connection cache parameter. Each time the number of connections
	 * exceeds this value ORB tries to reclaim connections. Number of reclaimed
	 * connections is specified by tcp-number-to-reclaim property. If this
	 * property is not set then it is configured as OpenJDK ORB default.
	 */
	@SuppressWarnings("unchecked")
	public T highWaterMark(java.lang.Integer value) {
		Object oldValue = this.highWaterMark;
		this.highWaterMark = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("highWaterMark", oldValue, value);
		return (T) this;
	}

	/**
	 * TCP connection cache parameter. Each time number of connections exceeds
	 * tcp-high-water-mark property then ORB tries to reclaim connections.
	 * Number of reclaimed connections is specified by this property. If it is
	 * not set then it is configured as OpenJDK ORB default.
	 */
	@ModelNodeBinding(detypedName = "number-to-reclaim")
	public Integer numberToReclaim() {
		return this.numberToReclaim;
	}

	/**
	 * TCP connection cache parameter. Each time number of connections exceeds
	 * tcp-high-water-mark property then ORB tries to reclaim connections.
	 * Number of reclaimed connections is specified by this property. If it is
	 * not set then it is configured as OpenJDK ORB default.
	 */
	@SuppressWarnings("unchecked")
	public T numberToReclaim(java.lang.Integer value) {
		Object oldValue = this.numberToReclaim;
		this.numberToReclaim = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberToReclaim", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether the transport must require confidentiality protection
	 * or not. Valid values are 'none', 'supported' and 'required'.
	 */
	@ModelNodeBinding(detypedName = "confidentiality")
	public Confidentiality confidentiality() {
		return this.confidentiality;
	}

	/**
	 * Indicates whether the transport must require confidentiality protection
	 * or not. Valid values are 'none', 'supported' and 'required'.
	 */
	@SuppressWarnings("unchecked")
	public T confidentiality(Confidentiality value) {
		Object oldValue = this.confidentiality;
		this.confidentiality = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("confidentiality", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether the transport must require misordering detection or
	 * not. Valid values are 'none', 'supported' and 'required'.
	 */
	@ModelNodeBinding(detypedName = "detect-misordering")
	public DetectMisordering detectMisordering() {
		return this.detectMisordering;
	}

	/**
	 * Indicates whether the transport must require misordering detection or
	 * not. Valid values are 'none', 'supported' and 'required'.
	 */
	@SuppressWarnings("unchecked")
	public T detectMisordering(DetectMisordering value) {
		Object oldValue = this.detectMisordering;
		this.detectMisordering = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("detectMisordering", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether the transport must require replay detection or not.
	 * Valid values are 'none', 'supported' and 'required'.
	 */
	@ModelNodeBinding(detypedName = "detect-replay")
	public DetectReplay detectReplay() {
		return this.detectReplay;
	}

	/**
	 * Indicates whether the transport must require replay detection or not.
	 * Valid values are 'none', 'supported' and 'required'.
	 */
	@SuppressWarnings("unchecked")
	public T detectReplay(DetectReplay value) {
		Object oldValue = this.detectReplay;
		this.detectReplay = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("detectReplay", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether the transport must require integrity protection or not.
	 * Valid values are 'none', 'supported' and 'required'.
	 */
	@ModelNodeBinding(detypedName = "integrity")
	public Integrity integrity() {
		return this.integrity;
	}

	/**
	 * Indicates whether the transport must require integrity protection or not.
	 * Valid values are 'none', 'supported' and 'required'.
	 */
	@SuppressWarnings("unchecked")
	public T integrity(Integrity value) {
		Object oldValue = this.integrity;
		this.integrity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("integrity", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates if the transport must require trust in client to be
	 * established. Valid values are 'none', 'supported' and 'required'.
	 */
	@ModelNodeBinding(detypedName = "trust-in-client")
	public TrustInClient trustInClient() {
		return this.trustInClient;
	}

	/**
	 * Indicates if the transport must require trust in client to be
	 * established. Valid values are 'none', 'supported' and 'required'.
	 */
	@SuppressWarnings("unchecked")
	public T trustInClient(TrustInClient value) {
		Object oldValue = this.trustInClient;
		this.trustInClient = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("trustInClient", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates if the transport must require trust in target to be
	 * established. Valid values are 'none' and 'supported'.
	 */
	@ModelNodeBinding(detypedName = "trust-in-target")
	public TrustInTarget trustInTarget() {
		return this.trustInTarget;
	}

	/**
	 * Indicates if the transport must require trust in target to be
	 * established. Valid values are 'none' and 'supported'.
	 */
	@SuppressWarnings("unchecked")
	public T trustInTarget(TrustInTarget value) {
		Object oldValue = this.trustInTarget;
		this.trustInTarget = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("trustInTarget", oldValue, value);
		return (T) this;
	}
}