package org.wildfly.swarm.config.jmx;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.jmx.configuration.HandlerConsumer;
import org.wildfly.swarm.config.jmx.configuration.HandlerSupplier;
import org.wildfly.swarm.config.jmx.configuration.Handler;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The management audit logging top-level resource.
 */
@Address("/subsystem=jmx/configuration=audit-log")
@ResourceType("configuration")
@Implicit
public class AuditLogConfiguration<T extends AuditLogConfiguration<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private AuditLogConfigurationResources subresources = new AuditLogConfigurationResources();
	@AttributeDocumentation("Whether audit logging is enabled.")
	private Boolean enabled;
	@AttributeDocumentation("Whether operations should be logged on server boot.")
	private Boolean logBoot;
	@AttributeDocumentation("Whether operations that do not modify the configuration or any runtime services should be logged.")
	private Boolean logReadOnly;

	public AuditLogConfiguration() {
		super();
		this.key = "audit-log";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public AuditLogConfigurationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Handler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Handler objects.
	 */
	@SuppressWarnings("unchecked")
	public T handlers(java.util.List<Handler> value) {
		this.subresources.handlers = value;
		return (T) this;
	}

	/**
	 * Add the Handler object to the list of subresources
	 * 
	 * @param value
	 *            The Handler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T handler(Handler value) {
		this.subresources.handlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Handler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Handler resource
	 * @param config
	 *            The HandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T handler(java.lang.String childKey, HandlerConsumer consumer) {
		Handler<? extends Handler> child = new Handler<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		handler(child);
		return (T) this;
	}

	/**
	 * Create and configure a Handler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Handler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T handler(java.lang.String childKey) {
		handler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Handler object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T handler(HandlerSupplier supplier) {
		handler(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for AuditLogConfiguration
	 */
	public static class AuditLogConfigurationResources {
		/**
		 * A reference to a file or syslog audit log handler. The name of the
		 * handler is denoted by the value of the address.
		 */
		@ResourceDocumentation("A reference to a file or syslog audit log handler. The name of the handler is denoted by the value of the address.")
		@SubresourceInfo("handler")
		private List<Handler> handlers = new java.util.ArrayList<>();

		/**
		 * Get the list of Handler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Handler> handlers() {
			return this.handlers;
		}

		public Handler handler(java.lang.String key) {
			return this.handlers.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}

	/**
	 * Whether audit logging is enabled.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Whether audit logging is enabled.
	 */
	@SuppressWarnings("unchecked")
	public T enabled(java.lang.Boolean value) {
		Object oldValue = this.enabled;
		this.enabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether operations should be logged on server boot.
	 */
	@ModelNodeBinding(detypedName = "log-boot")
	public Boolean logBoot() {
		return this.logBoot;
	}

	/**
	 * Whether operations should be logged on server boot.
	 */
	@SuppressWarnings("unchecked")
	public T logBoot(java.lang.Boolean value) {
		Object oldValue = this.logBoot;
		this.logBoot = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("logBoot", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether operations that do not modify the configuration or any runtime
	 * services should be logged.
	 */
	@ModelNodeBinding(detypedName = "log-read-only")
	public Boolean logReadOnly() {
		return this.logReadOnly;
	}

	/**
	 * Whether operations that do not modify the configuration or any runtime
	 * services should be logged.
	 */
	@SuppressWarnings("unchecked")
	public T logReadOnly(java.lang.Boolean value) {
		Object oldValue = this.logReadOnly;
		this.logReadOnly = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("logReadOnly", oldValue, value);
		return (T) this;
	}
}