package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.ConfigurationChangesService;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConfigurationChangesServiceConsumer<T extends ConfigurationChangesService<T>> {

	/**
	 * Configure a pre-constructed instance of ConfigurationChangesService
	 * resource
	 * 
	 * @parameter Instance of ConfigurationChangesService to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConfigurationChangesServiceConsumer<T> andThen(
			ConfigurationChangesServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}