package org.wildfly.swarm.config.undertow.configuration.reverse_proxy;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A host that the reverse proxy will forward requests to
 */
@Address("/subsystem=undertow/configuration=handler/reverse-proxy=*/host=*")
@ResourceType("host")
public class Host<T extends Host<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The instance id (aka JVM route) that will be used to enable sticky sessions")
	private String instanceId;
	@AttributeDocumentation("Outbound socket binding for this host")
	private String outboundSocketBinding;
	@AttributeDocumentation("Optional path if host is using non root resource")
	private String path;
	@AttributeDocumentation("What kind of scheme is used")
	private String scheme;
	@AttributeDocumentation("The security realm that provides the SSL configuration for the connection to the host")
	private String securityRealm;

	public Host(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The instance id (aka JVM route) that will be used to enable sticky
	 * sessions
	 */
	@ModelNodeBinding(detypedName = "instance-id")
	public String instanceId() {
		return this.instanceId;
	}

	/**
	 * The instance id (aka JVM route) that will be used to enable sticky
	 * sessions
	 */
	@SuppressWarnings("unchecked")
	public T instanceId(java.lang.String value) {
		Object oldValue = this.instanceId;
		this.instanceId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("instanceId", oldValue, value);
		return (T) this;
	}

	/**
	 * Outbound socket binding for this host
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding")
	public String outboundSocketBinding() {
		return this.outboundSocketBinding;
	}

	/**
	 * Outbound socket binding for this host
	 */
	@SuppressWarnings("unchecked")
	public T outboundSocketBinding(java.lang.String value) {
		Object oldValue = this.outboundSocketBinding;
		this.outboundSocketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("outboundSocketBinding", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Optional path if host is using non root resource
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Optional path if host is using non root resource
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * What kind of scheme is used
	 */
	@ModelNodeBinding(detypedName = "scheme")
	public String scheme() {
		return this.scheme;
	}

	/**
	 * What kind of scheme is used
	 */
	@SuppressWarnings("unchecked")
	public T scheme(java.lang.String value) {
		Object oldValue = this.scheme;
		this.scheme = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scheme", oldValue, value);
		return (T) this;
	}

	/**
	 * The security realm that provides the SSL configuration for the connection
	 * to the host
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The security realm that provides the SSL configuration for the connection
	 * to the host
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(java.lang.String value) {
		Object oldValue = this.securityRealm;
		this.securityRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityRealm", oldValue, value);
		return (T) this;
	}
}