/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ee;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=ee/context-service=*")
@ResourceType(value="context-service")
public class ContextService<T extends ContextService<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The JNDI Name to lookup the context service.")
    private String jndiName;
    @AttributeDocumentation(value="Flag which indicates if the transaction setup provider should be used")
    private Boolean useTransactionSetupProvider;

    public ContextService(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-transaction-setup-provider")
    public Boolean useTransactionSetupProvider() {
        return this.useTransactionSetupProvider;
    }

    public T useTransactionSetupProvider(Boolean value) {
        Boolean oldValue = this.useTransactionSetupProvider;
        this.useTransactionSetupProvider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useTransactionSetupProvider", oldValue, value);
        }
        return (T)this;
    }
}

