/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/core-service=management/access=audit/json-formatter=*")
@ResourceType(value="json-formatter")
public class JsonFormatter<T extends JsonFormatter<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="If true will format the JSON on one line. There may still be values containing new lines, so if having the whole record on one line is important, set escape-new-line or escape-control-characters to true.")
    private Boolean compact;
    @AttributeDocumentation(value="The date format to use as understood by {@link java.text.SimpleDateFormat}. Will be ignored if include-date=\"false\".")
    private String dateFormat;
    @AttributeDocumentation(value="The separator between the date and the rest of the formatted log message. Will be ignored if include-date=\"false\".")
    private String dateSeparator;
    @AttributeDocumentation(value="If true will escape all control characters (ascii entries with a decimal value < 32) with the ascii code in octal, e.g.'\n becomes '#012'. If this is true, it will override escape-new-line=\"false\".")
    private Boolean escapeControlCharacters;
    @AttributeDocumentation(value="If true will escape all new lines with the ascii code in octal, e.g. \"#012\".")
    private Boolean escapeNewLine;
    @AttributeDocumentation(value="Whether or not to include the date in the formatted log record.")
    private Boolean includeDate;

    public JsonFormatter(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="compact")
    public Boolean compact() {
        return this.compact;
    }

    public T compact(Boolean value) {
        Boolean oldValue = this.compact;
        this.compact = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("compact", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="date-format")
    public String dateFormat() {
        return this.dateFormat;
    }

    public T dateFormat(String value) {
        String oldValue = this.dateFormat;
        this.dateFormat = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dateFormat", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="date-separator")
    public String dateSeparator() {
        return this.dateSeparator;
    }

    public T dateSeparator(String value) {
        String oldValue = this.dateSeparator;
        this.dateSeparator = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dateSeparator", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="escape-control-characters")
    public Boolean escapeControlCharacters() {
        return this.escapeControlCharacters;
    }

    public T escapeControlCharacters(Boolean value) {
        Boolean oldValue = this.escapeControlCharacters;
        this.escapeControlCharacters = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("escapeControlCharacters", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="escape-new-line")
    public Boolean escapeNewLine() {
        return this.escapeNewLine;
    }

    public T escapeNewLine(Boolean value) {
        Boolean oldValue = this.escapeNewLine;
        this.escapeNewLine = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("escapeNewLine", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="include-date")
    public Boolean includeDate() {
        return this.includeDate;
    }

    public T includeDate(Boolean value) {
        Boolean oldValue = this.includeDate;
        this.includeDate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("includeDate", oldValue, value);
        }
        return (T)this;
    }
}

