/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/jms-bridge=*")
@ResourceType(value="jms-bridge")
public class JMSBridge<T extends JMSBridge<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="If true, then the original message's message ID will be appended in the message sent to the destination in the header AMQ_BRIDGE_MSG_ID_LIST. If the message is bridged more than once, each message ID will be appended.")
    private Boolean addMessageidInHeader;
    @AttributeDocumentation(value="The JMS client ID to use when creating/looking up the subscription if it is durable and the source destination is a topic.")
    private String clientId;
    @AttributeDocumentation(value="The amount of time in milliseconds to wait between trying to recreate connections to the source or target servers when the bridge has detected they have failed.")
    private Long failureRetryInterval;
    @AttributeDocumentation(value="The maximum number of messages to consume from the source destination before sending them in a batch to the target destination. Its value must >= 1.")
    private Integer maxBatchSize;
    @AttributeDocumentation(value="The maximum number of milliseconds to wait before sending a batch to target, even if the number of messages consumed has not reached max-batch-size. Its value must be -1 to represent 'wait forever', or >= 1 to specify an actual time.")
    private Long maxBatchTime;
    @AttributeDocumentation(value="The number of times to attempt to recreate connections to the source or target servers when the bridge has detected they have failed. The bridge will give up after trying this number of times. -1 represents 'try forever'.")
    private Integer maxRetries;
    @AttributeDocumentation(value="The name of AS7 module containing the resources required to lookup source and target JMS resources.")
    private String module;
    @AttributeDocumentation(value="Whether the JMS bridge is paused.")
    private Boolean paused;
    @AttributeDocumentation(value="The desired quality of service mode (AT_MOST_ONCE, DUPLICATES_OK or ONCE_AND_ONLY_ONCE).")
    private QualityOfService qualityOfService;
    @AttributeDocumentation(value="A JMS selector expression used for consuming messages from the source destination. Only messages that match the selector expression will be bridged from the source to the target destination.")
    private String selector;
    @AttributeDocumentation(value="Whether the JMS bridge is started.")
    private Boolean started;
    @AttributeDocumentation(value="The name of the subscription if it is durable and the source destination is a topic.")
    private String subscriptionName;
    @AttributeDocumentation(value="The name of the source connection factory to lookup on the source messaging server.")
    private String sourceConnectionFactory;
    @AttributeDocumentation(value="The properties used to configure the source JNDI initial context.")
    private Map sourceContext;
    @AttributeDocumentation(value="The name of the source destination to lookup on the source messaging server.")
    private String sourceDestination;
    @AttributeDocumentation(value="The password for creating the source connection.")
    private String sourcePassword;
    @AttributeDocumentation(value="The name of the user for creating the source connection.")
    private String sourceUser;
    @AttributeDocumentation(value="The name of the target connection factory to lookup on the target messaging server.")
    private String targetConnectionFactory;
    @AttributeDocumentation(value="The properties used to configure the target JNDI initial context.")
    private Map targetContext;
    @AttributeDocumentation(value="The name of the target destination to lookup on the target messaging server.")
    private String targetDestination;
    @AttributeDocumentation(value="The password for creating the target connection.")
    private String targetPassword;
    @AttributeDocumentation(value="The name of the user for creating the target connection.")
    private String targetUser;

    public JMSBridge(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="add-messageID-in-header")
    public Boolean addMessageidInHeader() {
        return this.addMessageidInHeader;
    }

    public T addMessageidInHeader(Boolean value) {
        Boolean oldValue = this.addMessageidInHeader;
        this.addMessageidInHeader = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("addMessageidInHeader", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-id")
    public String clientId() {
        return this.clientId;
    }

    public T clientId(String value) {
        String oldValue = this.clientId;
        this.clientId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientId", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="failure-retry-interval")
    public Long failureRetryInterval() {
        return this.failureRetryInterval;
    }

    public T failureRetryInterval(Long value) {
        Long oldValue = this.failureRetryInterval;
        this.failureRetryInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("failureRetryInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-batch-size")
    public Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    public T maxBatchSize(Integer value) {
        Integer oldValue = this.maxBatchSize;
        this.maxBatchSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxBatchSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-batch-time")
    public Long maxBatchTime() {
        return this.maxBatchTime;
    }

    public T maxBatchTime(Long value) {
        Long oldValue = this.maxBatchTime;
        this.maxBatchTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxBatchTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-retries")
    public Integer maxRetries() {
        return this.maxRetries;
    }

    public T maxRetries(Integer value) {
        Integer oldValue = this.maxRetries;
        this.maxRetries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRetries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="paused")
    public Boolean paused() {
        return this.paused;
    }

    public T paused(Boolean value) {
        Boolean oldValue = this.paused;
        this.paused = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("paused", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="quality-of-service")
    public QualityOfService qualityOfService() {
        return this.qualityOfService;
    }

    public T qualityOfService(QualityOfService value) {
        QualityOfService oldValue = this.qualityOfService;
        this.qualityOfService = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("qualityOfService", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="selector")
    public String selector() {
        return this.selector;
    }

    public T selector(String value) {
        String oldValue = this.selector;
        this.selector = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("selector", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="started")
    public Boolean started() {
        return this.started;
    }

    public T started(Boolean value) {
        Boolean oldValue = this.started;
        this.started = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("started", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="subscription-name")
    public String subscriptionName() {
        return this.subscriptionName;
    }

    public T subscriptionName(String value) {
        String oldValue = this.subscriptionName;
        this.subscriptionName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("subscriptionName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="source-connection-factory")
    public String sourceConnectionFactory() {
        return this.sourceConnectionFactory;
    }

    public T sourceConnectionFactory(String value) {
        String oldValue = this.sourceConnectionFactory;
        this.sourceConnectionFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sourceConnectionFactory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="source-context")
    public Map sourceContext() {
        return this.sourceContext;
    }

    public T sourceContext(Map value) {
        Map oldValue = this.sourceContext;
        this.sourceContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sourceContext", oldValue, value);
        }
        return (T)this;
    }

    public T sourceContext(String key, Object value) {
        if (this.sourceContext == null) {
            this.sourceContext = new HashMap();
        }
        this.sourceContext.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="source-destination")
    public String sourceDestination() {
        return this.sourceDestination;
    }

    public T sourceDestination(String value) {
        String oldValue = this.sourceDestination;
        this.sourceDestination = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sourceDestination", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="source-password")
    public String sourcePassword() {
        return this.sourcePassword;
    }

    public T sourcePassword(String value) {
        String oldValue = this.sourcePassword;
        this.sourcePassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sourcePassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="source-user")
    public String sourceUser() {
        return this.sourceUser;
    }

    public T sourceUser(String value) {
        String oldValue = this.sourceUser;
        this.sourceUser = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sourceUser", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="target-connection-factory")
    public String targetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public T targetConnectionFactory(String value) {
        String oldValue = this.targetConnectionFactory;
        this.targetConnectionFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("targetConnectionFactory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="target-context")
    public Map targetContext() {
        return this.targetContext;
    }

    public T targetContext(Map value) {
        Map oldValue = this.targetContext;
        this.targetContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("targetContext", oldValue, value);
        }
        return (T)this;
    }

    public T targetContext(String key, Object value) {
        if (this.targetContext == null) {
            this.targetContext = new HashMap();
        }
        this.targetContext.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="target-destination")
    public String targetDestination() {
        return this.targetDestination;
    }

    public T targetDestination(String value) {
        String oldValue = this.targetDestination;
        this.targetDestination = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("targetDestination", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="target-password")
    public String targetPassword() {
        return this.targetPassword;
    }

    public T targetPassword(String value) {
        String oldValue = this.targetPassword;
        this.targetPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("targetPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="target-user")
    public String targetUser() {
        return this.targetUser;
    }

    public T targetUser(String value) {
        String oldValue = this.targetUser;
        this.targetUser = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("targetUser", oldValue, value);
        }
        return (T)this;
    }

    public static enum QualityOfService {
        AT_MOST_ONCE("AT_MOST_ONCE"),
        DUPLICATES_OK("DUPLICATES_OK"),
        ONCE_AND_ONLY_ONCE("ONCE_AND_ONLY_ONCE");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private QualityOfService(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

