package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.ejb3.IdentityService;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface IdentityServiceConsumer<T extends IdentityService<T>> {

	/**
	 * Configure a pre-constructed instance of IdentityService resource
	 * 
	 * @parameter Instance of IdentityService to configure
	 * @return nothing
	 */
	void accept(T value);

	default IdentityServiceConsumer<T> andThen(IdentityServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}