package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AggregateRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregateRealmConsumer<T extends AggregateRealm<T>> {

	/**
	 * Configure a pre-constructed instance of AggregateRealm resource
	 * 
	 * @parameter Instance of AggregateRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregateRealmConsumer<T> andThen(AggregateRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}