package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ChainedPrincipalTransformer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ChainedPrincipalTransformerConsumer<T extends ChainedPrincipalTransformer<T>> {

	/**
	 * Configure a pre-constructed instance of ChainedPrincipalTransformer
	 * resource
	 * 
	 * @parameter Instance of ChainedPrincipalTransformer to configure
	 * @return nothing
	 */
	void accept(T value);

	default ChainedPrincipalTransformerConsumer<T> andThen(
			ChainedPrincipalTransformerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}